/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.docker.maven.config;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jolokia.docker.maven.config.Arguments;
import org.jolokia.docker.maven.config.LogConfiguration;
import org.jolokia.docker.maven.config.RestartPolicy;
import org.jolokia.docker.maven.config.VolumeConfiguration;
import org.jolokia.docker.maven.config.WaitConfiguration;

public class RunImageConfiguration {
    static final RunImageConfiguration DEFAULT = new RunImageConfiguration();
    private Map<String, String> env;
    private Map<String, String> labels;
    private String envPropertyFile;
    private Arguments cmd;
    private String domainname;
    private Arguments entrypoint;
    private String hostname;
    private String user;
    private String workingDir;
    private Long memory;
    private Long memorySwap;
    private String portPropertyFile;
    private List<String> dns;
    private List<String> dnsSearch;
    private List<String> capAdd;
    private List<String> capDrop;
    private Boolean privileged;
    private List<String> extraHosts;
    private List<String> ports;
    private NamingStrategy namingStrategy;
    private VolumeConfiguration volumes;
    private List<String> links;
    private WaitConfiguration wait;
    private LogConfiguration log;
    private RestartPolicy restartPolicy;
    private boolean skip = false;

    public void validate() {
        if (this.entrypoint != null) {
            this.entrypoint.validate();
        }
        if (this.cmd != null) {
            this.cmd.validate();
        }
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public String getEnvPropertyFile() {
        return this.envPropertyFile;
    }

    public Arguments getEntrypoint() {
        return this.entrypoint;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getDomainname() {
        return this.domainname;
    }

    public String getUser() {
        return this.user;
    }

    public Long getMemory() {
        return this.memory;
    }

    public Long getMemorySwap() {
        return this.memorySwap;
    }

    public List<String> getPorts() {
        return this.ports != null ? this.ports : Collections.emptyList();
    }

    public Arguments getCmd() {
        return this.cmd;
    }

    public String getPortPropertyFile() {
        return this.portPropertyFile;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public WaitConfiguration getWaitConfiguration() {
        return this.wait;
    }

    public LogConfiguration getLog() {
        return this.log;
    }

    public List<String> getCapAdd() {
        return this.capAdd;
    }

    public List<String> getCapDrop() {
        return this.capDrop;
    }

    public List<String> getDns() {
        return this.dns;
    }

    public List<String> getDnsSearch() {
        return this.dnsSearch;
    }

    public List<String> getExtraHosts() {
        return this.extraHosts;
    }

    public VolumeConfiguration getVolumeConfiguration() {
        return this.volumes;
    }

    public List<String> getLinks() {
        return this.links;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy == null ? NamingStrategy.none : this.namingStrategy;
    }

    public Boolean getPrivileged() {
        return this.privileged;
    }

    public RestartPolicy getRestartPolicy() {
        return this.restartPolicy == null ? RestartPolicy.DEFAULT : this.restartPolicy;
    }

    public boolean skip() {
        return this.skip;
    }

    public static class Builder {
        private RunImageConfiguration config = new RunImageConfiguration();

        public Builder env(Map<String, String> env) {
            this.config.env = env;
            return this;
        }

        public Builder labels(Map<String, String> labels) {
            this.config.labels = labels;
            return this;
        }

        public Builder envPropertyFile(String envPropertyFile) {
            this.config.envPropertyFile = envPropertyFile;
            return this;
        }

        public Builder cmd(String cmd) {
            this.config.cmd = new Arguments(cmd);
            return this;
        }

        public Builder domainname(String domainname) {
            this.config.domainname = domainname;
            return this;
        }

        public Builder entrypoint(String entrypoint) {
            this.config.entrypoint = new Arguments(entrypoint);
            return this;
        }

        public Builder hostname(String hostname) {
            this.config.hostname = hostname;
            return this;
        }

        public Builder portPropertyFile(String portPropertyFile) {
            this.config.portPropertyFile = portPropertyFile;
            return this;
        }

        public Builder workingDir(String workingDir) {
            this.config.workingDir = workingDir;
            return this;
        }

        public Builder user(String user) {
            this.config.user = user;
            return this;
        }

        public Builder memory(Long memory) {
            this.config.memory = memory;
            return this;
        }

        public Builder memorySwap(Long memorySwap) {
            this.config.memorySwap = memorySwap;
            return this;
        }

        public Builder capAdd(List<String> capAdd) {
            this.config.capAdd = capAdd;
            return this;
        }

        public Builder capDrop(List<String> capDrop) {
            this.config.capDrop = capDrop;
            return this;
        }

        public Builder dns(List<String> dns) {
            this.config.dns = dns;
            return this;
        }

        public Builder dnsSearch(List<String> dnsSearch) {
            this.config.dnsSearch = dnsSearch;
            return this;
        }

        public Builder extraHosts(List<String> extraHosts) {
            this.config.extraHosts = extraHosts;
            return this;
        }

        public Builder ports(List<String> ports) {
            this.config.ports = ports;
            return this;
        }

        public Builder volumes(VolumeConfiguration volumes) {
            this.config.volumes = volumes;
            return this;
        }

        public Builder links(List<String> links) {
            this.config.links = links;
            return this;
        }

        public Builder wait(WaitConfiguration wait) {
            this.config.wait = wait;
            return this;
        }

        public Builder log(LogConfiguration log) {
            this.config.log = log;
            return this;
        }

        public Builder namingStrategy(String namingStrategy) {
            this.config.namingStrategy = namingStrategy == null ? NamingStrategy.none : NamingStrategy.valueOf(namingStrategy.toLowerCase());
            return this;
        }

        public Builder privileged(Boolean privileged) {
            this.config.privileged = privileged;
            return this;
        }

        public Builder restartPolicy(RestartPolicy restartPolicy) {
            this.config.restartPolicy = restartPolicy;
            return this;
        }

        public Builder skip(String skip) {
            if (skip != null) {
                this.config.skip = Boolean.valueOf(skip);
            }
            return this;
        }

        public RunImageConfiguration build() {
            return this.config;
        }
    }

    public static enum NamingStrategy {
        none,
        alias;

    }
}

