/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.docker.maven.log;

import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import org.jolokia.docker.maven.access.DockerAccess;
import org.jolokia.docker.maven.access.log.LogGetHandle;
import org.jolokia.docker.maven.log.DefaultLogCallback;
import org.jolokia.docker.maven.log.LogOutputSpec;

public class LogDispatcher {
    private Map<String, LogGetHandle> logHandles;
    private DockerAccess dockerAccess;

    public LogDispatcher(DockerAccess dockerAccess) {
        this.dockerAccess = dockerAccess;
        this.logHandles = new HashMap<String, LogGetHandle>();
    }

    public synchronized void trackContainerLog(String containerId, LogOutputSpec spec) throws FileNotFoundException {
        LogGetHandle handle = this.dockerAccess.getLogAsync(containerId, new DefaultLogCallback(spec));
        this.logHandles.put(containerId, handle);
    }

    public synchronized void fetchContainerLog(String containerId, LogOutputSpec spec) throws FileNotFoundException {
        this.dockerAccess.getLogSync(containerId, new DefaultLogCallback(spec));
    }

    public synchronized void untrackAllContainerLogs() {
        for (String key : this.logHandles.keySet()) {
            LogGetHandle handle = this.logHandles.get(key);
            handle.finish();
        }
        this.logHandles.clear();
    }
}

