/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.docker.maven.log;

import org.fusesource.jansi.Ansi;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.jolokia.docker.maven.util.Timestamp;

public class LogOutputSpec {
    public static final LogOutputSpec DEFAULT = new LogOutputSpec("", Ansi.Color.YELLOW, null, null, null, true, true);
    private final String containerId;
    private final boolean useColor;
    private final boolean logStdout;
    private String prefix;
    private Ansi.Color color;
    private DateTimeFormatter timeFormatter;
    private String file;
    private static final Ansi.Color[] COLOR_PALETTE = new Ansi.Color[]{Ansi.Color.YELLOW, Ansi.Color.CYAN, Ansi.Color.MAGENTA, Ansi.Color.GREEN, Ansi.Color.RED, Ansi.Color.BLUE};
    private static int globalColorIdx = 0;

    private LogOutputSpec(String prefix, Ansi.Color color, DateTimeFormatter timeFormatter, String containerId, String file, boolean useColor, boolean logStdout) {
        this.prefix = prefix;
        this.color = color;
        this.containerId = containerId;
        this.timeFormatter = timeFormatter;
        this.file = file;
        this.useColor = useColor;
        this.logStdout = logStdout;
    }

    public boolean isUseColor() {
        return this.useColor && (this.file == null || this.logStdout);
    }

    public boolean isLogStdout() {
        return this.logStdout;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getPrompt(boolean withColor, Timestamp timestamp) {
        return this.formatTimestamp(timestamp, withColor) + this.formatPrefix(this.prefix, withColor) + "> ";
    }

    public String getFile() {
        return this.file;
    }

    private String formatTimestamp(Timestamp timestamp, boolean withColor) {
        if (this.timeFormatter == null) {
            return "";
        }
        String date = this.timeFormatter.print((ReadableInstant)timestamp.getDate());
        return (withColor ? Ansi.ansi().fgBright(Ansi.Color.BLACK).a(date).reset().toString() : date) + " ";
    }

    private String formatPrefix(String prefix, boolean withColor) {
        return withColor ? Ansi.ansi().fg(this.color).a(prefix).reset().toString() : prefix;
    }

    public static class Builder {
        private String prefix;
        private Ansi.Color color;
        private String containerId;
        private DateTimeFormatter timeFormatter;
        private String file;
        private boolean useColor;
        private boolean logStdout;

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder color(String color) {
            if (color == null) {
                this.color = COLOR_PALETTE[globalColorIdx++ % COLOR_PALETTE.length];
            } else {
                try {
                    this.color = Ansi.Color.valueOf((String)color.toUpperCase());
                }
                catch (IllegalArgumentException exp) {
                    throw new IllegalArgumentException("Invalid color '" + color + "'. Color must be one YELLOW, CYAN, MAGENTA, GREEN, RED or BLUE");
                }
            }
            return this;
        }

        public Builder file(String file) {
            this.file = file;
            return this;
        }

        public Builder timeFormatter(String formatOrConstant) {
            if (formatOrConstant == null || formatOrConstant.equalsIgnoreCase("NONE") || formatOrConstant.equalsIgnoreCase("FALSE")) {
                this.timeFormatter = null;
            } else if (formatOrConstant.length() == 0 || formatOrConstant.equalsIgnoreCase("DEFAULT")) {
                this.timeFormatter = DateTimeFormat.forPattern((String)"HH:mm:ss.SSS");
            } else if (formatOrConstant.equalsIgnoreCase("ISO8601")) {
                this.timeFormatter = ISODateTimeFormat.dateTime();
            } else if (formatOrConstant.equalsIgnoreCase("SHORT")) {
                this.timeFormatter = DateTimeFormat.shortDateTime();
            } else if (formatOrConstant.equalsIgnoreCase("MEDIUM")) {
                this.timeFormatter = DateTimeFormat.mediumDateTime();
            } else if (formatOrConstant.equalsIgnoreCase("LONG")) {
                this.timeFormatter = DateTimeFormat.longDateTime();
            } else {
                try {
                    this.timeFormatter = DateTimeFormat.forPattern((String)formatOrConstant);
                }
                catch (IllegalArgumentException exp) {
                    throw new IllegalArgumentException("Cannot parse log date specification '" + formatOrConstant + "'." + "Must be either DEFAULT, NONE, ISO8601, SHORT, MEDIUM, LONG or a " + "format string parseable by DateTimeFormat. See " + "http://joda-time.sourceforge.net/apidocs/org/joda/time/format/DateTimeFormat.html");
                }
            }
            return this;
        }

        public Builder containerId(String id) {
            this.containerId = id;
            return this;
        }

        public Builder useColor(boolean useColor) {
            this.useColor = useColor;
            return this;
        }

        public Builder logStdout(boolean logStdout) {
            this.logStdout = logStdout;
            return this;
        }

        public LogOutputSpec build() {
            return new LogOutputSpec(this.prefix, this.color, this.timeFormatter, this.containerId, this.file, this.useColor, this.logStdout);
        }
    }
}

