/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.docker.maven.model;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.jolokia.docker.maven.model.Container;
import org.json.JSONObject;

public class ContainerDetails
implements Container {
    static final String CONFIG = "Config";
    static final String HOST_IP = "HostIp";
    static final String HOST_PORT = "HostPort";
    static final String NAME = "Name";
    static final String NETWORK_SETTINGS = "NetworkSettings";
    static final String STATE = "State";
    static String CREATED = "Created";
    static String ID = "Id";
    static String IMAGE = "Image";
    static String PORTS = "Ports";
    static String SLASH = "/";
    private static final String RUNNING = "Running";
    private final JSONObject json;

    public ContainerDetails(JSONObject json) {
        this.json = json;
    }

    @Override
    public long getCreated() {
        String date = this.json.getString(CREATED);
        Calendar cal = DatatypeConverter.parseDateTime((String)date);
        return cal.getTimeInMillis();
    }

    @Override
    public String getId() {
        return this.json.getString(ID).substring(0, 12);
    }

    @Override
    public String getImage() {
        return this.json.getJSONObject(CONFIG).getString(IMAGE);
    }

    @Override
    public String getName() {
        String name = this.json.getString(NAME);
        if (name.startsWith(SLASH)) {
            name = name.substring(1);
        }
        return name;
    }

    @Override
    public Map<String, Container.PortBinding> getPortBindings() {
        JSONObject networkSettings;
        if (this.json.has(NETWORK_SETTINGS) && !this.json.isNull(NETWORK_SETTINGS) && !(networkSettings = this.json.getJSONObject(NETWORK_SETTINGS)).isNull(PORTS)) {
            return this.createPortBindings(networkSettings.getJSONObject(PORTS));
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean isRunning() {
        JSONObject state = this.json.getJSONObject(STATE);
        return state.getBoolean(RUNNING);
    }

    private void addPortMapping(String port, JSONObject hostConfig, Map<String, Container.PortBinding> portBindings) {
        String hostIp = hostConfig.getString(HOST_IP);
        Integer hostPort = Integer.valueOf(hostConfig.getString(HOST_PORT));
        this.addPortMapping(port, new Container.PortBinding(hostPort, hostIp), portBindings);
    }

    private void addPortMapping(String port, Container.PortBinding binding, Map<String, Container.PortBinding> portBindings) {
        if (port.indexOf(47) == -1) {
            port = port + "/tcp";
        }
        portBindings.put(port, binding);
    }

    private Map<String, Container.PortBinding> createPortBindings(JSONObject ports) {
        HashMap<String, Container.PortBinding> portBindings = new HashMap<String, Container.PortBinding>();
        for (Object obj : ports.keySet()) {
            String port = obj.toString();
            if (ports.isNull(port)) {
                this.addPortMapping(port, (Container.PortBinding)null, portBindings);
                continue;
            }
            JSONObject hostConfig = ports.getJSONArray(port).getJSONObject(0);
            this.addPortMapping(port, hostConfig, portBindings);
        }
        return portBindings;
    }
}

