/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.docker.maven.service;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.jolokia.docker.maven.access.DockerAccess;
import org.jolokia.docker.maven.access.DockerAccessException;
import org.jolokia.docker.maven.assembly.AssemblyFiles;
import org.jolokia.docker.maven.assembly.DockerAssemblyManager;
import org.jolokia.docker.maven.config.BuildImageConfiguration;
import org.jolokia.docker.maven.config.ImageConfiguration;
import org.jolokia.docker.maven.service.QueryService;
import org.jolokia.docker.maven.util.Logger;
import org.jolokia.docker.maven.util.MojoParameters;

public class BuildService {
    private final DockerAccess docker;
    private final QueryService queryService;
    private final Logger log;
    private DockerAssemblyManager dockerAssemblyManager;

    BuildService(DockerAccess docker, QueryService queryService, DockerAssemblyManager dockerAssemblyManager, Logger log) {
        this.docker = docker;
        this.queryService = queryService;
        this.dockerAssemblyManager = dockerAssemblyManager;
        this.log = log;
    }

    public void buildImage(ImageConfiguration imageConfig, MojoParameters params) throws DockerAccessException, MojoExecutionException {
        String imageName = imageConfig.getName();
        BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
        String oldImageId = null;
        if (buildConfig.cleanup()) {
            oldImageId = this.queryService.getImageId(imageName);
        }
        String newImageId = this.buildImage(imageName, buildConfig, params);
        this.log.info(imageConfig.getDescription() + ": Built image " + newImageId);
        if (this.oldImageShouldBeRemoved(oldImageId, newImageId)) {
            this.docker.removeImage(oldImageId, new boolean[0]);
            this.log.info(imageConfig.getDescription() + ": Removed image " + oldImageId);
        }
    }

    public AssemblyFiles getAssemblyFiles(ImageConfiguration imageConfig, MojoParameters mojoParameters) throws MojoExecutionException {
        String name = imageConfig.getName();
        try {
            return this.dockerAssemblyManager.getAssemblyFiles(name, imageConfig.getBuildConfiguration(), mojoParameters, this.log);
        }
        catch (InvalidAssemblerConfigurationException | ArchiveCreationException | AssemblyFormattingException e) {
            throw new MojoExecutionException("Cannot extract assembly files for image " + name + ": " + e, (Exception)e);
        }
    }

    public File createChangedFilesArchive(List<AssemblyFiles.Entry> entries, File assemblyDir, String imageName, MojoParameters mojoParameters) throws MojoExecutionException {
        return this.dockerAssemblyManager.createChangedFilesArchive(entries, assemblyDir, imageName, mojoParameters);
    }

    private String buildImage(String imageName, BuildImageConfiguration buildConfig, MojoParameters mojoParameters) throws DockerAccessException, MojoExecutionException {
        File dockerArchive = this.createArchive(imageName, buildConfig, mojoParameters);
        this.docker.buildImage(imageName, dockerArchive, buildConfig.cleanup());
        return this.queryService.getImageId(imageName);
    }

    private File createArchive(String imageName, BuildImageConfiguration buildConfig, MojoParameters params) throws MojoExecutionException {
        return this.dockerAssemblyManager.createDockerTarArchive(imageName, params, buildConfig);
    }

    private boolean oldImageShouldBeRemoved(String oldImageId, String newImageId) {
        return oldImageId != null && !oldImageId.equals(newImageId);
    }
}

