/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.docker.maven.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jolokia.docker.maven.config.ImageConfiguration;
import org.jolokia.docker.maven.config.RunImageConfiguration;
import org.jolokia.docker.maven.config.WaitConfiguration;

public class ContainerTracker {
    private final Map<String, String> imageToContainerMap = new HashMap<String, String>();
    private final Map<String, String> aliasToContainerMap = new HashMap<String, String>();
    private final Map<String, ContainerShutdownDescriptor> shutdownDescriptorMap = new LinkedHashMap<String, ContainerShutdownDescriptor>();

    public void registerContainer(String containerId, ImageConfiguration imageConfig) {
        this.shutdownDescriptorMap.put(containerId, new ContainerShutdownDescriptor(imageConfig, containerId));
        this.updateImageToContainerMapping(imageConfig, containerId);
    }

    public ContainerShutdownDescriptor getContainerShutdownDescriptor(String containerId) {
        return this.shutdownDescriptorMap.get(containerId);
    }

    public ContainerShutdownDescriptor removeContainerShutdownDescriptor(String containerId) {
        return this.shutdownDescriptorMap.remove(containerId);
    }

    public String lookupContainer(String lookup) {
        if (this.aliasToContainerMap.containsKey(lookup)) {
            return this.aliasToContainerMap.get(lookup);
        }
        return this.imageToContainerMap.get(lookup);
    }

    public void resetContainers() {
        this.shutdownDescriptorMap.clear();
    }

    public Collection<ContainerShutdownDescriptor> getAllContainerShutdownDescriptors() {
        ArrayList<ContainerShutdownDescriptor> descriptors = new ArrayList<ContainerShutdownDescriptor>(this.shutdownDescriptorMap.values());
        Collections.reverse(descriptors);
        return descriptors;
    }

    private void updateImageToContainerMapping(ImageConfiguration imageConfig, String id) {
        this.imageToContainerMap.put(imageConfig.getName(), id);
        if (imageConfig.getAlias() != null) {
            this.aliasToContainerMap.put(imageConfig.getAlias(), id);
        }
    }

    static class ContainerShutdownDescriptor {
        private final ImageConfiguration imageConfig;
        private final String containerId;
        private int shutdownGracePeriod;
        private int killGracePeriod;
        private String preStop;

        ContainerShutdownDescriptor(ImageConfiguration imageConfig, String containerId) {
            this.imageConfig = imageConfig;
            this.containerId = containerId;
            RunImageConfiguration runConfig = imageConfig.getRunConfiguration();
            WaitConfiguration waitConfig = runConfig != null ? runConfig.getWaitConfiguration() : null;
            this.shutdownGracePeriod = waitConfig != null ? waitConfig.getShutdown() : 0;
            int n = this.killGracePeriod = waitConfig != null ? waitConfig.getKill() : 0;
            if (waitConfig != null && waitConfig.getExec() != null) {
                this.preStop = waitConfig.getExec().getPreStop();
            }
        }

        public ImageConfiguration getImageConfiguration() {
            return this.imageConfig;
        }

        public String getImage() {
            return this.imageConfig.getName();
        }

        public String getContainerId() {
            return this.containerId;
        }

        public String getDescription() {
            return this.imageConfig.getDescription();
        }

        public int getShutdownGracePeriod() {
            return this.shutdownGracePeriod;
        }

        public int getKillGracePeriod() {
            return this.killGracePeriod;
        }

        public String getPreStop() {
            return this.preStop;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContainerShutdownDescriptor that = (ContainerShutdownDescriptor)o;
            return this.containerId.equals(that.containerId);
        }

        public int hashCode() {
            return this.containerId.hashCode();
        }
    }
}

