/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.docker.maven.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.jolokia.docker.maven.access.ContainerCreateConfig;
import org.jolokia.docker.maven.access.ContainerHostConfig;
import org.jolokia.docker.maven.access.DockerAccess;
import org.jolokia.docker.maven.access.DockerAccessException;
import org.jolokia.docker.maven.access.PortMapping;
import org.jolokia.docker.maven.config.Arguments;
import org.jolokia.docker.maven.config.ImageConfiguration;
import org.jolokia.docker.maven.config.RestartPolicy;
import org.jolokia.docker.maven.config.RunImageConfiguration;
import org.jolokia.docker.maven.config.VolumeConfiguration;
import org.jolokia.docker.maven.log.LogOutputSpecFactory;
import org.jolokia.docker.maven.model.Container;
import org.jolokia.docker.maven.service.ContainerTracker;
import org.jolokia.docker.maven.service.QueryService;
import org.jolokia.docker.maven.util.EnvUtil;
import org.jolokia.docker.maven.util.Logger;
import org.jolokia.docker.maven.util.StartOrderResolver;
import org.jolokia.docker.maven.util.WaitUtil;

public class RunService {
    private Logger log;
    private final ContainerTracker tracker;
    private DockerAccess docker;
    private QueryService queryService;
    private final LogOutputSpecFactory logConfig;

    public RunService(DockerAccess docker, QueryService queryService, ContainerTracker tracker, LogOutputSpecFactory logConfig, Logger log) {
        this.docker = docker;
        this.queryService = queryService;
        this.tracker = tracker;
        this.log = log;
        this.logConfig = logConfig;
    }

    public String execInContainer(String containerId, String command, ImageConfiguration imageConfiguration) throws DockerAccessException {
        Arguments arguments = new Arguments();
        arguments.setExec(Arrays.asList(EnvUtil.splitOnSpaceWithEscape(command)));
        String execContainerId = this.docker.createExecContainer(containerId, arguments);
        this.docker.startExecContainer(execContainerId, this.logConfig.createSpec(containerId, imageConfiguration));
        return execContainerId;
    }

    public String createAndStartContainer(ImageConfiguration imageConfig, PortMapping mappedPorts, Properties mavenProps) throws DockerAccessException {
        RunImageConfiguration runConfig = imageConfig.getRunConfiguration();
        String imageName = imageConfig.getName();
        String containerName = this.calculateContainerName(imageConfig.getAlias(), runConfig.getNamingStrategy());
        ContainerCreateConfig config = this.createContainerConfig(imageName, runConfig, mappedPorts, mavenProps);
        String id = this.docker.createContainer(config, containerName);
        this.startContainer(imageConfig, id);
        if (mappedPorts.containsDynamicPorts()) {
            this.updateMappedPorts(id, mappedPorts);
        }
        return id;
    }

    public void stopContainer(String containerId, ImageConfiguration imageConfig, boolean keepContainer, boolean removeVolumes) throws DockerAccessException {
        ContainerTracker.ContainerShutdownDescriptor descriptor = new ContainerTracker.ContainerShutdownDescriptor(imageConfig, containerId);
        this.shutdown(this.docker, descriptor, this.log, keepContainer, removeVolumes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopContainer(String containerId, boolean keepContainer, boolean removeVolumes) throws DockerAccessException {
        ContainerTracker containerTracker = this.tracker;
        synchronized (containerTracker) {
            ContainerTracker.ContainerShutdownDescriptor descriptor = this.tracker.getContainerShutdownDescriptor(containerId);
            if (descriptor != null) {
                this.shutdown(this.docker, descriptor, this.log, keepContainer, removeVolumes);
                this.tracker.removeContainerShutdownDescriptor(containerId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopStartedContainers(boolean keepContainer, boolean removeVolumes) throws DockerAccessException {
        ContainerTracker containerTracker = this.tracker;
        synchronized (containerTracker) {
            for (ContainerTracker.ContainerShutdownDescriptor descriptor : this.tracker.getAllContainerShutdownDescriptors()) {
                this.shutdown(this.docker, descriptor, this.log, keepContainer, removeVolumes);
            }
            this.tracker.resetContainers();
        }
    }

    public String lookupContainer(String lookup) {
        return this.tracker.lookupContainer(lookup);
    }

    public List<StartOrderResolver.Resolvable> getImagesConfigsInOrder(QueryService queryService, List<ImageConfiguration> images) {
        return StartOrderResolver.resolve(queryService, this.convertToResolvables(images));
    }

    public PortMapping getPortMapping(RunImageConfiguration runConfig, Properties properties) {
        try {
            return new PortMapping(runConfig.getPorts(), properties);
        }
        catch (IllegalArgumentException exp) {
            throw new IllegalArgumentException("Cannot parse port mapping", exp);
        }
    }

    public void addShutdownHookForStoppingContainers(final boolean keepContainer, final boolean removeVolumes) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    RunService.this.stopStartedContainers(keepContainer, removeVolumes);
                }
                catch (DockerAccessException e) {
                    RunService.this.log.error("Error while stopping containers: " + e);
                }
            }
        });
    }

    private List<StartOrderResolver.Resolvable> convertToResolvables(List<ImageConfiguration> images) {
        ArrayList<StartOrderResolver.Resolvable> ret = new ArrayList<StartOrderResolver.Resolvable>();
        for (ImageConfiguration config : images) {
            if (config.getRunConfiguration().skip()) {
                this.log.info(config.getDescription() + ": Skipped running");
                continue;
            }
            ret.add(config);
        }
        return ret;
    }

    ContainerCreateConfig createContainerConfig(String imageName, RunImageConfiguration runConfig, PortMapping mappedPorts, Properties mavenProps) throws DockerAccessException {
        try {
            ContainerCreateConfig config = new ContainerCreateConfig(imageName).hostname(runConfig.getHostname()).domainname(runConfig.getDomainname()).user(runConfig.getUser()).workingDir(runConfig.getWorkingDir()).memory(runConfig.getMemory()).memorySwap(runConfig.getMemorySwap()).entrypoint(runConfig.getEntrypoint()).exposedPorts(mappedPorts.getContainerPorts()).environment(runConfig.getEnvPropertyFile(), runConfig.getEnv(), mavenProps).labels(runConfig.getLabels()).command(runConfig.getCmd()).hostConfig(this.createContainerHostConfig(runConfig, mappedPorts));
            VolumeConfiguration volumeConfig = runConfig.getVolumeConfiguration();
            if (volumeConfig != null) {
                config.binds(volumeConfig.getBind());
            }
            return config;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Failed to create contained configuration for [%s]", imageName), e);
        }
    }

    ContainerHostConfig createContainerHostConfig(RunImageConfiguration runConfig, PortMapping mappedPorts) throws DockerAccessException {
        RestartPolicy restartPolicy = runConfig.getRestartPolicy();
        List<String> links = this.findLinksContainers(runConfig.getLinks());
        ContainerHostConfig config = new ContainerHostConfig().extraHosts(runConfig.getExtraHosts()).links(links).portBindings(mappedPorts).privileged(runConfig.getPrivileged()).dns(runConfig.getDns()).dnsSearch(runConfig.getDnsSearch()).capAdd(runConfig.getCapAdd()).capDrop(runConfig.getCapDrop()).restartPolicy(restartPolicy.getName(), restartPolicy.getRetry());
        VolumeConfiguration volConfig = runConfig.getVolumeConfiguration();
        if (volConfig != null) {
            config.binds(volConfig.getBind()).volumesFrom(this.findVolumesFromContainers(volConfig.getFrom()));
        }
        return config;
    }

    List<String> findLinksContainers(List<String> links) throws DockerAccessException {
        ArrayList<String> ret = new ArrayList<String>();
        for (String[] link : EnvUtil.splitOnLastColon(links)) {
            String id = this.findContainerId(link[0], false);
            if (id == null) {
                throw new DockerAccessException("No container found for image/alias '%s', unable to link", link[0]);
            }
            ret.add(this.queryService.getContainerName(id) + ":" + link[1]);
        }
        return ret.size() != 0 ? ret : null;
    }

    List<String> findVolumesFromContainers(List<String> images) throws DockerAccessException {
        ArrayList<String> list = new ArrayList<String>();
        if (images != null) {
            for (String image : images) {
                String id = this.findContainerId(image, true);
                if (id == null) {
                    throw new DockerAccessException("No container found for image/alias '%s', unable to mount volumes", image);
                }
                list.add(this.queryService.getContainerName(id));
            }
        }
        return list;
    }

    private String calculateContainerName(String alias, RunImageConfiguration.NamingStrategy namingStrategy) {
        if (namingStrategy == RunImageConfiguration.NamingStrategy.none) {
            return null;
        }
        if (alias == null) {
            throw new IllegalArgumentException("A naming scheme 'alias' requires an image alias to be set");
        }
        return alias;
    }

    private String findContainerId(String imageNameOrAlias, boolean checkAllContainers) throws DockerAccessException {
        Container container;
        String id = this.lookupContainer(imageNameOrAlias);
        if (id == null && (container = this.queryService.getContainerByName(imageNameOrAlias)) != null && (checkAllContainers || container.isRunning())) {
            id = container.getId();
        }
        return id;
    }

    private void startContainer(ImageConfiguration imageConfig, String id) throws DockerAccessException {
        this.log.info(imageConfig.getDescription() + ": Start container " + id);
        this.docker.startContainer(id);
        this.tracker.registerContainer(id, imageConfig);
    }

    private void updateMappedPorts(String containerId, PortMapping mappedPorts) throws DockerAccessException {
        Container container = this.queryService.getContainer(containerId);
        mappedPorts.updateVariablesWithDynamicPorts(container.getPortBindings());
    }

    private void shutdown(DockerAccess access, ContainerTracker.ContainerShutdownDescriptor descriptor, Logger log, boolean keepContainer, boolean removeVolumes) throws DockerAccessException {
        String containerId = descriptor.getContainerId();
        if (descriptor.getPreStop() != null) {
            try {
                this.execInContainer(containerId, descriptor.getPreStop(), descriptor.getImageConfiguration());
            }
            catch (DockerAccessException e) {
                log.error(e.getMessage());
            }
        }
        int killGracePeriod = descriptor.getKillGracePeriod();
        int killGracePeriodInSeconds = (killGracePeriod + 500) / 1000;
        if (killGracePeriod != 0 && killGracePeriodInSeconds == 0) {
            log.warn("A kill grace period of " + killGracePeriod + "ms leads to no wait at all since its rounded to seconds. " + "Please use at least 500 as value for wait.kill");
        }
        access.stopContainer(containerId, killGracePeriodInSeconds);
        if (killGracePeriod > 0) {
            log.debug("Shutdown: Wait " + killGracePeriodInSeconds + " s after stopping and before killing container");
            WaitUtil.sleep(killGracePeriodInSeconds * 1000);
        }
        if (!keepContainer) {
            int shutdownGracePeriod = descriptor.getShutdownGracePeriod();
            if (shutdownGracePeriod != 0) {
                log.debug("Shutdown: Wait " + shutdownGracePeriod + " ms before removing container");
                WaitUtil.sleep(shutdownGracePeriod);
            }
            access.removeContainer(containerId, removeVolumes);
        }
        log.info(descriptor.getDescription() + ": Stop" + (keepContainer ? "" : " and remove") + " container " + containerId.substring(0, 12));
    }
}

