/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.docker.maven.service;

import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.project.MavenProject;
import org.jolokia.docker.maven.access.DockerAccess;
import org.jolokia.docker.maven.assembly.DockerAssemblyManager;
import org.jolokia.docker.maven.log.LogOutputSpecFactory;
import org.jolokia.docker.maven.service.BuildService;
import org.jolokia.docker.maven.service.ContainerTracker;
import org.jolokia.docker.maven.service.MojoExecutionService;
import org.jolokia.docker.maven.service.QueryService;
import org.jolokia.docker.maven.service.RunService;
import org.jolokia.docker.maven.util.Logger;

public class ServiceHub {
    private final ContainerTracker containerTracker = new ContainerTracker();
    protected BuildPluginManager pluginManager;
    protected DockerAssemblyManager dockerAssemblyManager;
    protected MavenProject project;
    protected MavenSession session;
    private MojoExecutionService mojoExecutionService;
    private QueryService queryService;
    private RunService runService;
    private LogOutputSpecFactory logOutputSpecFactory;
    private BuildService buildService;
    private boolean initDone = false;

    public synchronized void init(DockerAccess dockerAccess, Logger log, LogOutputSpecFactory logOutputSpecFactory) {
        if (!this.initDone) {
            this.logOutputSpecFactory = logOutputSpecFactory;
            this.mojoExecutionService = new MojoExecutionService(this.project, this.session, this.pluginManager);
            this.queryService = new QueryService(dockerAccess, log);
            this.runService = new RunService(dockerAccess, this.queryService, this.containerTracker, logOutputSpecFactory, log);
            this.buildService = new BuildService(dockerAccess, this.queryService, this.dockerAssemblyManager, log);
            this.initDone = true;
        }
    }

    public MojoExecutionService getMojoExecutionService() {
        this.checkInitialization();
        return this.mojoExecutionService;
    }

    public BuildService getBuildService() {
        this.checkInitialization();
        return this.buildService;
    }

    public QueryService getQueryService() {
        this.checkInitialization();
        return this.queryService;
    }

    public RunService getRunService() {
        this.checkInitialization();
        return this.runService;
    }

    private synchronized void checkInitialization() {
        if (!this.initDone) {
            throw new IllegalStateException("Service hub not yet initialized");
        }
    }

    public LogOutputSpecFactory getLogOutputSpecFactory() {
        return this.logOutputSpecFactory;
    }
}

