/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.docker.maven.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jolokia.docker.maven.access.AuthConfig;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;

public class AuthConfigFactory {
    private static final String DOCKER_USERNAME = "docker.username";
    private static final String DOCKER_PASSWORD = "docker.password";
    private static final String DOCKER_EMAIL = "docker.email";
    private static final String DOCKER_AUTH = "docker.authToken";
    private final PlexusContainer container;
    public static final String[] DEFAULT_REGISTRIES = new String[]{"docker.io", "index.docker.io", "registry.hub.docker.com"};

    public AuthConfigFactory(PlexusContainer container) {
        this.container = container;
    }

    public AuthConfig createAuthConfig(Map authConfig, Settings settings, String user, String registry) throws MojoExecutionException {
        Properties props = System.getProperties();
        if (props.containsKey(DOCKER_USERNAME) || props.containsKey(DOCKER_PASSWORD)) {
            return this.getAuthConfigFromProperties(props);
        }
        if (authConfig != null) {
            return this.getAuthConfigFromPluginConfiguration(authConfig);
        }
        return this.getAuthConfigFromSettings(settings, user, registry);
    }

    private AuthConfig getAuthConfigFromProperties(Properties props) throws MojoExecutionException {
        if (!props.containsKey(DOCKER_USERNAME)) {
            throw new MojoExecutionException("No docker.username given when using authentication");
        }
        if (!props.containsKey(DOCKER_PASSWORD)) {
            throw new MojoExecutionException("No docker.password provided for username " + props.getProperty(DOCKER_USERNAME));
        }
        return new AuthConfig(props.getProperty(DOCKER_USERNAME), this.decrypt(props.getProperty(DOCKER_PASSWORD)), props.getProperty(DOCKER_EMAIL), props.getProperty(DOCKER_AUTH));
    }

    private AuthConfig getAuthConfigFromPluginConfiguration(Map authConfig) throws MojoExecutionException {
        for (String key : new String[]{"username", "password"}) {
            if (authConfig.containsKey(key)) continue;
            throw new MojoExecutionException("No '" + key + "' given while using <authConfig> in configuration");
        }
        HashMap<String, String> cloneConfig = new HashMap<String, String>(authConfig);
        cloneConfig.put("password", this.decrypt((String)cloneConfig.get("password")));
        return new AuthConfig(cloneConfig);
    }

    private AuthConfig getAuthConfigFromSettings(Settings settings, String user, String registry) throws MojoExecutionException {
        Server defaultServer = null;
        Server found = null;
        for (Server server : settings.getServers()) {
            String id = server.getId();
            if (defaultServer == null) {
                defaultServer = this.checkForServer(server, id, registry, null);
            }
            if ((found = this.checkForServer(server, id, registry, user)) == null) continue;
            return this.createAuthConfigFromServer(found);
        }
        return defaultServer != null ? this.createAuthConfigFromServer(defaultServer) : null;
    }

    private Server checkForServer(Server server, String id, String registry, String user) {
        String[] registries;
        String[] stringArray;
        if (registry != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = registry;
        } else {
            stringArray = DEFAULT_REGISTRIES;
        }
        for (String reg : registries = stringArray) {
            if (!id.equals(user == null ? reg : reg + "/" + user)) continue;
            return server;
        }
        return null;
    }

    private String decrypt(String password) throws MojoExecutionException {
        try {
            Object secDispatcher = this.container.lookup(SecDispatcher.ROLE, "maven");
            Method method = secDispatcher.getClass().getMethod("decrypt", String.class);
            return (String)method.invoke(secDispatcher, password);
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("Error looking security dispatcher", (Exception)((Object)e));
        }
        catch (ReflectiveOperationException e) {
            throw new MojoExecutionException("Cannot decrypt password: " + e.getCause(), (Exception)e);
        }
    }

    private AuthConfig createAuthConfigFromServer(Server server) throws MojoExecutionException {
        return new AuthConfig(server.getUsername(), this.decrypt(server.getPassword()), this.extractFromServerConfiguration(server.getConfiguration(), "email"), this.extractFromServerConfiguration(server.getConfiguration(), "auth"));
    }

    private String extractFromServerConfiguration(Object configuration, String prop) {
        Xpp3Dom dom;
        Xpp3Dom element;
        if (configuration != null && (element = (dom = (Xpp3Dom)configuration).getChild(prop)) != null) {
            return element.getValue();
        }
        return null;
    }
}

