/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.docker.maven.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImageName {
    private String repository;
    private String registry;
    private String tag;
    private String user;

    public ImageName(String fullName) {
        this(fullName, null);
    }

    public ImageName(String fullName, String givenTag) {
        if (fullName == null) {
            throw new NullPointerException("Image name must not be null");
        }
        Pattern tagPattern = Pattern.compile("^(.+?)(?::([^:/]+))?$");
        Matcher matcher = tagPattern.matcher(fullName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(fullName + " is not a proper image name ([registry/][repo][:port]");
        }
        this.tag = givenTag != null ? givenTag : (matcher.groupCount() > 1 ? matcher.group(2) : null);
        String rest = matcher.group(1);
        String[] parts = rest.split("\\s*/\\s*");
        if (parts.length == 1) {
            this.registry = null;
            this.user = null;
            this.repository = parts[0];
        } else if (parts.length >= 2) {
            if (this.isRegistry(parts[0])) {
                this.registry = parts[0];
                this.user = parts[1];
                this.repository = this.joinTail(parts);
            } else {
                this.registry = null;
                this.user = parts[0];
                this.repository = rest;
            }
        }
    }

    public String getRepository() {
        return this.repository;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean hasRegistry() {
        return this.registry != null && this.registry.length() > 0;
    }

    private String joinTail(String[] parts) {
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i < parts.length; ++i) {
            builder.append(parts[i]);
            if (i >= parts.length - 1) continue;
            builder.append("/");
        }
        return builder.toString();
    }

    private boolean isRegistry(String part) {
        return part.contains(".") || part.contains(":");
    }

    public String getNameWithoutTag() {
        return this.getNameWithoutTag(null);
    }

    public String getNameWithoutTag(String optionalRegistry) {
        StringBuilder ret = new StringBuilder();
        if (this.registry != null || optionalRegistry != null) {
            ret.append(this.registry != null ? this.registry : optionalRegistry).append("/");
        }
        ret.append(this.repository);
        return ret.toString();
    }

    public String getFullName() {
        return this.getFullName(null);
    }

    public String getFullName(String optionalRegistry) {
        return this.getNameWithoutTag(optionalRegistry) + ":" + (this.tag != null ? this.tag : "latest");
    }

    public String getUser() {
        return this.user;
    }
}

