/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.history;

import javax.management.MalformedObjectNameException;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.service.history.HistoryKey;
import org.jolokia.service.history.HistoryLimit;
import org.jolokia.service.history.HistoryMBean;
import org.jolokia.service.history.HistoryStore;
import org.jolokia.shaded.org.json.simple.JSONObject;

public class History
implements HistoryMBean {
    private final HistoryStore store;

    public History(HistoryStore pStore) {
        this.store = pStore;
    }

    @Override
    public void updateAndAdd(JolokiaRequest pJmxReq, JSONObject pJson) {
        this.store.updateAndAdd(pJmxReq, pJson);
    }

    @Override
    public void setHistoryEntriesForAttribute(String pMBean, String pAttribute, String pPath, String pTarget, int pMaxEntries) throws MalformedObjectNameException {
        this.setHistoryLimitForAttribute(pMBean, pAttribute, pPath, pTarget, pMaxEntries, 0L);
    }

    @Override
    public void setHistoryLimitForAttribute(String pMBean, String pAttribute, String pPath, String pTarget, int pMaxEntries, long pMaxDuration) throws MalformedObjectNameException {
        HistoryKey key = new HistoryKey(pMBean, pAttribute, pPath, pTarget);
        this.store.configure(key, this.limitOrNull(pMaxEntries, pMaxDuration));
    }

    @Override
    public void setHistoryEntriesForOperation(String pMBean, String pOperation, String pTarget, int pMaxEntries) throws MalformedObjectNameException {
        this.setHistoryLimitForOperation(pMBean, pOperation, pTarget, pMaxEntries, 0L);
    }

    @Override
    public void setHistoryLimitForOperation(String pMBean, String pOperation, String pTarget, int pMaxEntries, long pMaxDuration) throws MalformedObjectNameException {
        HistoryKey key = new HistoryKey(pMBean, pOperation, pTarget);
        this.store.configure(key, this.limitOrNull(pMaxEntries, pMaxDuration));
    }

    @Override
    public void resetHistoryEntries() {
        this.store.reset();
    }

    @Override
    public int getHistoryMaxEntries() {
        return this.store.getGlobalMaxEntries();
    }

    @Override
    public void setHistoryMaxEntries(int pLimit) {
        this.store.setGlobalMaxEntries(pLimit);
    }

    @Override
    public int getHistorySize() {
        return this.store.getSize();
    }

    private HistoryLimit limitOrNull(int pMaxEntries, long pMaxDuration) {
        return pMaxEntries != 0 || pMaxDuration != 0L ? new HistoryLimit(pMaxEntries, pMaxDuration) : null;
    }
}

