/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.security;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpPrincipal;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Stack;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jolokia.server.core.util.EscapeUtil;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class DelegatingAuthenticator
extends Authenticator {
    private final URL delegateURL;
    private final PrincipalExtractor principalExtractor;
    private final String realm;
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;

    public DelegatingAuthenticator(String pRealm, String pUrl, String pPrincipalSpec, boolean pDisableCertCheck) {
        this.realm = pRealm;
        try {
            this.delegateURL = new URL(pUrl);
            this.principalExtractor = this.createPrincipalExtractor(pPrincipalSpec);
            if (pDisableCertCheck) {
                this.disableSSLCertificateChecking();
            }
        }
        catch (MalformedURLException exp) {
            throw new IllegalArgumentException("Invalid delegation url '" + pUrl + "' given: " + exp, exp);
        }
    }

    @Override
    public Authenticator.Result authenticate(HttpExchange pHttpExchange) {
        try {
            URLConnection connection = this.delegateURL.openConnection();
            String authorization = pHttpExchange.getRequestHeaders().getFirst("Authorization");
            if (authorization == null) {
                authorization = pHttpExchange.getRequestHeaders().getFirst("X-jolokia-authorization");
            }
            connection.addRequestProperty("Authorization", authorization);
            connection.setConnectTimeout(2000);
            connection.connect();
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                if (connection instanceof HttpsURLConnection) {
                    HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                    if (this.sslSocketFactory != null) {
                        httpsConnection.setSSLSocketFactory(this.sslSocketFactory);
                    }
                    if (this.hostnameVerifier != null) {
                        httpsConnection.setHostnameVerifier(this.hostnameVerifier);
                    }
                }
                return httpConnection.getResponseCode() == 200 ? new Authenticator.Success(this.principalExtractor.extract(connection)) : new Authenticator.Failure(401);
            }
            return new Authenticator.Failure(401);
        }
        catch (IOException e) {
            return this.prepareFailure(pHttpExchange, "Cannot call delegate url " + this.delegateURL + ": " + e, 503);
        }
        catch (IllegalArgumentException e) {
            return this.prepareFailure(pHttpExchange, "Illegal Argument: " + e, 400);
        }
        catch (ParseException e) {
            return this.prepareFailure(pHttpExchange, "Invalid JSON response: " + e, 422);
        }
    }

    private Authenticator.Result prepareFailure(HttpExchange pHttpExchange, String pErrorDetails, int pCode) {
        pHttpExchange.getResponseHeaders().add("X-Error-Details", pErrorDetails);
        return new Authenticator.Failure(pCode);
    }

    private PrincipalExtractor createPrincipalExtractor(String pPrincipalExtractorSpec) {
        if (pPrincipalExtractorSpec == null || pPrincipalExtractorSpec.startsWith("empty:")) {
            return new EmptyPrincipalExtractor();
        }
        if (pPrincipalExtractorSpec.startsWith("json:")) {
            return new JsonPathExtractor(pPrincipalExtractorSpec.substring("json:".length()));
        }
        throw new IllegalArgumentException("No principal extractor found for spec '" + pPrincipalExtractorSpec + "'");
    }

    private void disableSSLCertificateChecking() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            this.sslSocketFactory = sc.getSocketFactory();
            this.hostnameVerifier = (hostname, session) -> true;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Disabling SSL certificate failed: " + e, e);
        }
    }

    private static interface PrincipalExtractor {
        public HttpPrincipal extract(URLConnection var1) throws IOException, ParseException;
    }

    private class EmptyPrincipalExtractor
    implements PrincipalExtractor {
        private EmptyPrincipalExtractor() {
        }

        @Override
        public HttpPrincipal extract(URLConnection connection) {
            return new HttpPrincipal("", DelegatingAuthenticator.this.realm);
        }
    }

    private class JsonPathExtractor
    implements PrincipalExtractor {
        private final String path;

        public JsonPathExtractor(String pPath) {
            this.path = pPath;
        }

        @Override
        public HttpPrincipal extract(URLConnection connection) throws IOException, ParseException {
            try (InputStreamReader isr = new InputStreamReader(connection.getInputStream());){
                Object payload = new JSONParser().parse((Reader)isr);
                Stack pathElements = EscapeUtil.extractElementsFromPath((String)this.path);
                Object result = payload;
                while (!pathElements.isEmpty()) {
                    if (result == null) {
                        throw new IllegalArgumentException("No path '" + this.path + "' found in " + payload);
                    }
                    String key = (String)pathElements.pop();
                    result = this.extractValue(result, key);
                }
                HttpPrincipal httpPrincipal = new HttpPrincipal(result.toString(), DelegatingAuthenticator.this.realm);
                return httpPrincipal;
            }
        }

        private Object extractValue(Object payload, String key) {
            if (payload instanceof JSONObject) {
                return ((JSONObject)payload).get((Object)key);
            }
            if (payload instanceof JSONArray) {
                return ((JSONArray)payload).get(Integer.parseInt(key));
            }
            return null;
        }
    }
}

