/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.detector.jee;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.server.core.detector.ServerDetector;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.request.RequestInterceptor;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;

public abstract class AbstractServerDetector
implements ServerDetector {
    private final int order;
    private Map<String, Object> config;
    private final String name;
    private static final MBeanServerAccess.MBeanAction<String> GET_ATTRIBUTE_HANDLER = new MBeanServerAccess.MBeanAction<String>(){

        @Override
        public String execute(MBeanServerConnection pConn, ObjectName pName, Object ... extraArgs) throws ReflectionException, InstanceNotFoundException, IOException, MBeanException, AttributeNotFoundException {
            Object attr = pConn.getAttribute(pName, (String)extraArgs[0]);
            return attr != null ? attr.toString() : null;
        }
    };

    protected AbstractServerDetector(String pName, int pOrder) {
        this.order = pOrder;
        this.name = pName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void init(Map<String, Object> pConfig) {
        this.config = pConfig;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void init(JolokiaContext pJolokiaContext) {
    }

    @Override
    public boolean isEnabled(JolokiaContext pContext) {
        return true;
    }

    protected Object getConfig(String pKey) {
        if (this.config == null) {
            return null;
        }
        return this.config.get(pKey);
    }

    protected Set<ObjectName> searchMBeans(MBeanServerAccess pMBeanServerAccess, String pMbeanPattern) {
        try {
            ObjectName oName = new ObjectName(pMbeanPattern);
            return pMBeanServerAccess.queryNames(oName);
        }
        catch (IOException | MalformedObjectNameException e) {
            return new HashSet<ObjectName>();
        }
    }

    protected boolean mBeanExists(MBeanServerAccess pMBeanServerManger, String pObjectName) {
        return !this.searchMBeans(pMBeanServerManger, pObjectName).isEmpty();
    }

    protected String getAttributeValue(MBeanServerAccess pMBeanServerAccess, String pMBean, String pAttribute) {
        try {
            ObjectName oName = new ObjectName(pMBean);
            return this.getAttributeValue(pMBeanServerAccess, oName, pAttribute);
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    protected String getAttributeValue(MBeanServerAccess pMBeanServerAccess, ObjectName pMBean, String pAttribute) {
        try {
            return pMBeanServerAccess.call(pMBean, GET_ATTRIBUTE_HANDLER, pAttribute);
        }
        catch (IOException | JMException e) {
            return null;
        }
    }

    protected String getSingleStringAttribute(MBeanServerAccess pMBeanServerAccess, String pMBeanName, String pAttribute) {
        Set<ObjectName> serverMBeanNames = this.searchMBeans(pMBeanServerAccess, pMBeanName);
        if (serverMBeanNames.isEmpty()) {
            return null;
        }
        HashSet<String> attributeValues = new HashSet<String>();
        for (ObjectName oName : serverMBeanNames) {
            String val = this.getAttributeValue(pMBeanServerAccess, oName, pAttribute);
            if (val == null) continue;
            attributeValues.add(val);
        }
        if (attributeValues.size() != 1) {
            return null;
        }
        return (String)attributeValues.iterator().next();
    }

    protected String getVersionFromJsr77(MBeanServerAccess pMbeanServers) {
        Set<ObjectName> names = this.searchMBeans(pMbeanServers, "*:j2eeType=J2EEServer,*");
        if (!names.isEmpty()) {
            return this.getAttributeValue(pMbeanServers, names.iterator().next(), "serverVersion");
        }
        return null;
    }

    @Override
    public Set<MBeanServerConnection> getMBeanServers() {
        return null;
    }

    @Override
    public RequestInterceptor getRequestInterceptor(MBeanServerAccess pMBeanServerAccess) {
        return null;
    }

    @Override
    public int compareTo(ServerDetector pDetector) {
        int ret = this.getOrder() - pDetector.getOrder();
        return ret != 0 ? ret : (this.equals(pDetector) ? 0 : this.hashCode() - pDetector.hashCode());
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractServerDetector that = (AbstractServerDetector)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public void jvmAgentStartup(Instrumentation instrumentation) {
    }

    protected boolean isClassLoaded(String className, Instrumentation instrumentation) {
        Class[] classes;
        if (instrumentation == null || className == null) {
            throw new IllegalArgumentException("instrumentation and className must not be null");
        }
        for (Class c : classes = instrumentation.getAllLoadedClasses()) {
            if (!className.equals(c.getName())) continue;
            return true;
        }
        return false;
    }
}

