/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.http;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.management.RuntimeMBeanException;
import javax.security.auth.Subject;
import org.jolokia.json.JSONStructure;
import org.jolokia.server.core.config.ConfigExtractor;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.config.Configuration;
import org.jolokia.server.core.config.StaticConfiguration;
import org.jolokia.server.core.detector.ServerDetectorLookup;
import org.jolokia.server.core.http.BackChannelHolder;
import org.jolokia.server.core.http.HttpRequestHandler;
import org.jolokia.server.core.http.ServletBackChannel;
import org.jolokia.server.core.request.EmptyResponseException;
import org.jolokia.server.core.restrictor.RestrictorFactory;
import org.jolokia.server.core.service.JolokiaServiceManagerFactory;
import org.jolokia.server.core.service.api.AgentDetails;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.api.JolokiaServiceManager;
import org.jolokia.server.core.service.api.LogHandler;
import org.jolokia.server.core.service.api.Restrictor;
import org.jolokia.server.core.service.impl.ClasspathServiceCreator;
import org.jolokia.server.core.util.ClassUtil;
import org.jolokia.server.core.util.IoUtil;
import org.jolokia.server.core.util.MimeTypeUtil;
import org.jolokia.server.core.util.NetworkUtil;

public class AgentServlet
extends HttpServlet {
    private static final long serialVersionUID = 42L;
    private ServletRequestHandler httpGetHandler;
    private ServletRequestHandler httpPostHandler;
    private HttpRequestHandler requestHandler;
    private final Restrictor initRestrictor;
    private boolean initAgentUrlFromRequest = false;
    private JolokiaContext jolokiaContext;
    private String configMimeType;
    private JolokiaServiceManager serviceManager;
    private boolean allowDnsReverseLookup;

    public AgentServlet() {
        this(null);
    }

    public AgentServlet(Restrictor pRestrictor) {
        this.initRestrictor = pRestrictor;
    }

    public void init(ServletConfig pServletConfig) throws ServletException {
        super.init(pServletConfig);
        Configuration config = this.createConfig(pServletConfig);
        LogHandler logHandler = this.createLogHandler(pServletConfig, config);
        Restrictor restrictor = this.createRestrictor(config, logHandler);
        this.serviceManager = JolokiaServiceManagerFactory.createJolokiaServiceManager(config, logHandler, restrictor, this.getServerDetectorLookup());
        this.initServices(pServletConfig, this.serviceManager);
        this.jolokiaContext = this.serviceManager.start();
        this.requestHandler = new HttpRequestHandler(this.jolokiaContext);
        this.allowDnsReverseLookup = Boolean.parseBoolean(config.getConfig(ConfigKey.ALLOW_DNS_REVERSE_LOOKUP));
        this.httpGetHandler = this.newGetHttpRequestHandler();
        this.httpPostHandler = this.newPostHttpRequestHandler();
        this.initAgentUrl();
        this.configMimeType = config.getConfig(ConfigKey.MIME_TYPE);
    }

    public void destroy() {
        this.serviceManager.stop();
    }

    protected void initServices(ServletConfig pServletConfig, JolokiaServiceManager pServiceManager) {
        pServiceManager.addServices(new ClasspathServiceCreator(AgentServlet.class.getClassLoader(), "services"));
    }

    protected ServerDetectorLookup getServerDetectorLookup() {
        return null;
    }

    protected Configuration createConfig(ServletConfig pServletConfig) {
        StaticConfiguration config = new StaticConfiguration(Collections.singletonMap(ConfigKey.AGENT_ID.getKeyValue(), NetworkUtil.getAgentId(((Object)((Object)this)).hashCode(), "servlet")));
        config.update(new ServletConfigFacade(pServletConfig));
        config.update(new ServletContextFacade(this.getServletContext()));
        config.update(this.configFromEnvironment());
        return config;
    }

    private Configuration configFromEnvironment() {
        HashMap<String, String> envConfig = new HashMap<String, String>();
        for (ConfigKey key : new ConfigKey[]{ConfigKey.DISCOVERY_AGENT_URL, ConfigKey.DISCOVERY_ENABLED}) {
            String value = System.getProperty(key.asSystemProperty());
            if (value == null) {
                value = System.getenv(key.asEnvVariable());
            }
            if (value == null) continue;
            envConfig.put(key.getKeyValue(), value);
        }
        return new StaticConfiguration(envConfig);
    }

    protected LogHandler createLogHandler(ServletConfig pServletConfig, Configuration pConfig) {
        String logHandlerClass = pConfig.getConfig(ConfigKey.LOGHANDLER_CLASS);
        String logHandlerName = pConfig.getConfig(ConfigKey.LOGHANDLER_NAME);
        boolean debug = Boolean.parseBoolean(pConfig.getConfig(ConfigKey.DEBUG));
        return logHandlerClass != null ? ClassUtil.newLogHandlerInstance(logHandlerClass, logHandlerName, debug) : new ServletLogHandler(debug);
    }

    protected Restrictor createRestrictor(Configuration pConfig, LogHandler pLogHandler) {
        return this.initRestrictor != null ? this.initRestrictor : RestrictorFactory.createRestrictor(pConfig, pLogHandler);
    }

    private void initAgentUrl() {
        String url = NetworkUtil.replaceExpression(this.jolokiaContext.getConfig(ConfigKey.DISCOVERY_AGENT_URL, true));
        if (url == null) {
            this.initAgentUrlFromRequest = true;
        } else {
            this.initAgentUrlFromRequest = false;
            this.jolokiaContext.getAgentDetails().updateAgentParameters(url, null);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.handle(this.httpGetHandler, req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.handle(this.httpPostHandler, req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) {
        Map<String, String> responseHeaders = this.requestHandler.handleCorsPreflightRequest(this.getOriginOrReferer(req), req.getHeader("Access-Control-Request-Headers"));
        for (Map.Entry<String, String> entry : responseHeaders.entrySet()) {
            resp.setHeader(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(ServletRequestHandler pReqHandler, HttpServletRequest pReq, HttpServletResponse pResp) throws IOException {
        JSONStructure json = null;
        try {
            this.requestHandler.checkAccess(pReq.getScheme(), this.allowDnsReverseLookup ? pReq.getRemoteHost() : null, pReq.getRemoteAddr(), this.getOriginOrReferer(pReq));
            this.validateCallbackIfGiven(pReq);
            this.updateAgentDetailsIfNeeded(pReq);
            this.prepareBackChannel(pReq);
            json = this.handleSecurely(pReqHandler, pReq, pResp);
        }
        catch (EmptyResponseException exp) {
            return;
        }
        catch (Throwable exp) {
            try {
                json = this.requestHandler.handleThrowable(exp instanceof RuntimeMBeanException ? ((RuntimeMBeanException)exp).getTargetException() : exp);
            }
            catch (Throwable exp2) {
                exp2.printStackTrace();
            }
        }
        finally {
            this.releaseBackChannel();
            this.setCorsHeader(pReq, pResp);
            if (json == null) {
                json = this.requestHandler.handleThrowable(new Exception("Internal error while handling an exception"));
            }
        }
        this.sendResponse(pResp, pReq, json);
    }

    private void releaseBackChannel() {
        BackChannelHolder.remove();
    }

    private void prepareBackChannel(HttpServletRequest pReq) {
        BackChannelHolder.set(new ServletBackChannel(pReq));
    }

    private JSONStructure handleSecurely(ServletRequestHandler pReqHandler, HttpServletRequest pReq, HttpServletResponse pResp) throws IOException, PrivilegedActionException, EmptyResponseException {
        Subject subject = (Subject)pReq.getAttribute("org.jolokia.jaasSubject");
        if (subject != null) {
            try {
                return Subject.doAs(subject, () -> pReqHandler.handleRequest(pReq, pResp));
            }
            catch (PrivilegedActionException exp) {
                Throwable innerExp = exp.getCause();
                if (innerExp instanceof EmptyResponseException) {
                    throw (EmptyResponseException)innerExp;
                }
                throw exp;
            }
        }
        return pReqHandler.handleRequest(pReq, pResp);
    }

    private String getOriginOrReferer(HttpServletRequest pReq) {
        String origin = pReq.getHeader("Origin");
        if (origin == null) {
            origin = pReq.getHeader("Referer");
        }
        return origin != null ? origin.replaceAll("[\\n\\r]*", "") : null;
    }

    private void updateAgentDetailsIfNeeded(HttpServletRequest pReq) {
        if (this.initAgentUrlFromRequest) {
            this.updateAgentUrl(NetworkUtil.sanitizeLocalUrl(pReq.getRequestURL().toString()), this.extractServletPath(pReq), pReq.getAuthType() != null);
            this.initAgentUrlFromRequest = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAgentUrl(String pRequestUrl, String pServletPath, boolean pIsAuthenticated) {
        AgentDetails details = this.jolokiaContext.getAgentDetails();
        if (details.isInitRequired()) {
            AgentDetails agentDetails = details;
            synchronized (agentDetails) {
                if (details.isInitRequired()) {
                    if (details.isUrlMissing()) {
                        String url = this.getBaseUrl(NetworkUtil.sanitizeLocalUrl(pRequestUrl), pServletPath);
                        details.setUrl(url);
                    }
                    if (details.isSecuredMissing()) {
                        details.setSecured(pIsAuthenticated);
                    }
                    details.seal();
                }
            }
        }
        details.seal();
    }

    private String getBaseUrl(String pUrl, String pServletPath) {
        String sUrl;
        try {
            URL url = new URL(pUrl);
            String host = this.getIpIfPossible(url.getHost());
            sUrl = new URL(url.getProtocol(), host, url.getPort(), pServletPath).toExternalForm();
        }
        catch (MalformedURLException exp) {
            sUrl = this.plainReplacement(pUrl, pServletPath);
        }
        return sUrl;
    }

    private String getIpIfPossible(String pHost) {
        try {
            InetAddress address = InetAddress.getByName(pHost);
            return address.getHostAddress();
        }
        catch (UnknownHostException e) {
            return pHost;
        }
    }

    private String plainReplacement(String pUrl, String pServletPath) {
        int idx = pUrl.lastIndexOf(pServletPath);
        Object url = idx != -1 ? pUrl.substring(0, idx) + pServletPath : pUrl;
        return url;
    }

    private String extractServletPath(HttpServletRequest pReq) {
        int len = pReq.getContextPath().length();
        if (len == 0) {
            len = pReq.getServletPath().length();
        }
        return pReq.getRequestURI().substring(0, len);
    }

    private void setCorsHeader(HttpServletRequest pReq, HttpServletResponse pResp) {
        String origin = this.requestHandler.extractCorsOrigin(pReq.getHeader("Origin"));
        if (origin != null) {
            pResp.setHeader("Access-Control-Allow-Origin", origin);
            pResp.setHeader("Access-Control-Allow-Credentials", "true");
        }
    }

    private ServletRequestHandler newPostHttpRequestHandler() {
        return new ServletRequestHandler(){

            @Override
            public JSONStructure handleRequest(HttpServletRequest pReq, HttpServletResponse pResp) throws IOException, EmptyResponseException {
                String encoding = pReq.getCharacterEncoding();
                ServletInputStream is = pReq.getInputStream();
                return AgentServlet.this.requestHandler.handlePostRequest(pReq.getRequestURI(), (InputStream)is, encoding, AgentServlet.this.getParameterMap(pReq));
            }
        };
    }

    private ServletRequestHandler newGetHttpRequestHandler() {
        return new ServletRequestHandler(){

            @Override
            public JSONStructure handleRequest(HttpServletRequest pReq, HttpServletResponse pResp) throws EmptyResponseException {
                return AgentServlet.this.requestHandler.handleGetRequest(pReq.getRequestURI(), pReq.getPathInfo(), AgentServlet.this.getParameterMap(pReq));
            }
        };
    }

    private Map<String, String[]> getParameterMap(HttpServletRequest pReq) {
        try {
            return pReq.getParameterMap();
        }
        catch (UnsupportedOperationException exp) {
            HashMap<String, String[]> ret = new HashMap<String, String[]>();
            Enumeration params = pReq.getParameterNames();
            while (params.hasMoreElements()) {
                String param = (String)params.nextElement();
                ret.put(param, pReq.getParameterValues(param));
            }
            return ret;
        }
    }

    private void sendResponse(HttpServletResponse pResp, HttpServletRequest pReq, JSONStructure pJson) throws IOException {
        String callback = pReq.getParameter(ConfigKey.CALLBACK.getKeyValue());
        this.setContentType(pResp, MimeTypeUtil.getResponseMimeType(pReq.getParameter(ConfigKey.MIME_TYPE.getKeyValue()), this.configMimeType, callback));
        pResp.setStatus(200);
        this.setNoCacheHeaders(pResp);
        if (pJson == null) {
            pResp.setContentLength(-1);
        } else {
            this.sendStreamingResponse(pResp, callback, pJson);
        }
    }

    private void validateCallbackIfGiven(HttpServletRequest pReq) {
        String callback = pReq.getParameter(ConfigKey.CALLBACK.getKeyValue());
        if (callback != null && !MimeTypeUtil.isValidCallback(callback)) {
            throw new IllegalArgumentException("Invalid callback name given, which must be a valid javascript function name");
        }
    }

    private void sendStreamingResponse(HttpServletResponse pResp, String pCallback, JSONStructure pJson) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)pResp.getOutputStream(), StandardCharsets.UTF_8);
        IoUtil.streamResponseAndClose(writer, pJson, pCallback);
    }

    private void setNoCacheHeaders(HttpServletResponse pResp) {
        pResp.setHeader("Cache-Control", "no-cache");
        pResp.setHeader("Pragma", "no-cache");
        long now = System.currentTimeMillis();
        pResp.setDateHeader("Date", now);
        pResp.setDateHeader("Expires", now - 3600000L);
    }

    private void setContentType(HttpServletResponse pResp, String pContentType) {
        boolean encodingDone = false;
        try {
            pResp.setCharacterEncoding("utf-8");
            pResp.setContentType(pContentType);
            encodingDone = true;
        }
        catch (NoSuchMethodError noSuchMethodError) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (!encodingDone) {
            pResp.setContentType(pContentType + "; charset=utf-8");
        }
    }

    private static interface ServletRequestHandler {
        public JSONStructure handleRequest(HttpServletRequest var1, HttpServletResponse var2) throws IOException, EmptyResponseException;
    }

    private static final class ServletConfigFacade
    implements ConfigExtractor {
        private final ServletConfig config;

        private ServletConfigFacade(ServletConfig pConfig) {
            this.config = pConfig;
        }

        @Override
        public Enumeration<String> getNames() {
            return this.config.getInitParameterNames();
        }

        @Override
        public String getParameter(String pName) {
            return this.config.getInitParameter(pName);
        }
    }

    private static final class ServletContextFacade
    implements ConfigExtractor {
        private final ServletContext servletContext;

        private ServletContextFacade(ServletContext pServletContext) {
            this.servletContext = pServletContext;
        }

        @Override
        public Enumeration<String> getNames() {
            return this.servletContext.getInitParameterNames();
        }

        @Override
        public String getParameter(String pName) {
            return this.servletContext.getInitParameter(pName);
        }
    }

    private final class ServletLogHandler
    implements LogHandler {
        private final boolean debug;

        private ServletLogHandler(boolean pDebug) {
            this.debug = pDebug;
        }

        @Override
        public void debug(String message) {
            AgentServlet.this.log(message);
        }

        @Override
        public void info(String message) {
            AgentServlet.this.log(message);
        }

        @Override
        public void error(String message, Throwable t) {
            AgentServlet.this.log(message, t);
        }

        @Override
        public boolean isDebug() {
            return this.debug;
        }
    }
}

