/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.util.LocalServiceFactory;
import org.jolokia.server.core.util.RequestType;
import org.jolokia.service.jmx.api.CommandHandler;

public class CommandHandlerManager {
    private final Map<RequestType, CommandHandler<?>> requestHandlerMap = new HashMap();

    public CommandHandlerManager(JolokiaContext pCtx) {
        this(pCtx, null);
    }

    public CommandHandlerManager(JolokiaContext pCtx, String pProvider) {
        List<CommandHandler> handlers = LocalServiceFactory.createServices(this.getClass().getClassLoader(), "META-INF/jolokia/command-handlers");
        if (LocalServiceFactory.validateServices(handlers, pCtx)) {
            for (CommandHandler handler : handlers) {
                handler.init(pCtx, pProvider);
                this.requestHandlerMap.put(handler.getType(), handler);
            }
        }
    }

    public <R extends JolokiaRequest> CommandHandler<R> getCommandHandler(RequestType pType) {
        CommandHandler<?> handler = this.requestHandlerMap.get((Object)pType);
        if (handler == null) {
            throw new UnsupportedOperationException("Unsupported operation '" + pType + "'");
        }
        return handler;
    }

    public void destroy() throws JMException {
        for (CommandHandler<?> handler : this.requestHandlerMap.values()) {
            handler.destroy();
        }
    }
}

