/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client;

import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.VersionInfo;
import org.jolokia.client.J4pClient;
import org.jolokia.client.request.J4pTargetConfig;

public class J4pClientBuilder {
    private HttpParams params = new BasicHttpParams();
    private boolean pooledConnections;
    private String url;
    private String user;
    private String password;
    private String targetUrl;
    private String targetUser;
    private String targetPassword;

    public J4pClientBuilder() {
        this.connectionTimeout(20000);
        this.maxTotalConnections(20);
        this.maxConnectionPoolTimeout(500);
        this.contentCharset("ISO-8859-1");
        this.expectContinue(true);
        this.tcpNoDelay(true);
        this.socketBufferSize(8192);
        this.pooledConnections();
        this.user = null;
        this.password = null;
        HttpProtocolParams.setVersion((HttpParams)this.params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        VersionInfo vi = VersionInfo.loadVersionInfo((String)"org.apache.http.client", (ClassLoader)this.getClass().getClassLoader());
        String release = vi != null ? vi.getRelease() : "UNAVAILABLE";
        HttpProtocolParams.setUserAgent((HttpParams)this.params, (String)("Jolokia JMX-Client (using Apache-HttpClient/" + release + ")"));
    }

    public final J4pClientBuilder url(String pUrl) {
        this.url = pUrl;
        return this;
    }

    public final J4pClientBuilder user(String pUser) {
        this.user = pUser;
        return this;
    }

    public final J4pClientBuilder password(String pPassword) {
        this.password = pPassword;
        return this;
    }

    public final J4pClientBuilder target(String pUrl) {
        this.targetUrl = pUrl;
        return this;
    }

    public final J4pClientBuilder targetUser(String pUser) {
        this.targetUser = pUser;
        return this;
    }

    public final J4pClientBuilder targetPassword(String pPassword) {
        this.targetPassword = pPassword;
        return this;
    }

    public final J4pClientBuilder singleConnection() {
        this.pooledConnections = false;
        return this;
    }

    public final J4pClientBuilder pooledConnections() {
        this.pooledConnections = true;
        return this;
    }

    public final J4pClientBuilder connectionTimeout(int pTimeOut) {
        HttpConnectionParams.setConnectionTimeout((HttpParams)this.params, (int)pTimeOut);
        return this;
    }

    public final J4pClientBuilder socketTimeout(int pTimeOut) {
        HttpConnectionParams.setSoTimeout((HttpParams)this.params, (int)pTimeOut);
        return this;
    }

    public final J4pClientBuilder maxTotalConnections(int pConnections) {
        ConnManagerParams.setMaxTotalConnections((HttpParams)this.params, (int)pConnections);
        return this;
    }

    public final J4pClientBuilder maxConnectionPoolTimeout(int pConnectionPoolTimeout) {
        ConnManagerParams.setTimeout((HttpParams)this.params, (long)pConnectionPoolTimeout);
        return this;
    }

    public final J4pClientBuilder contentCharset(String pContentCharset) {
        HttpProtocolParams.setContentCharset((HttpParams)this.params, (String)pContentCharset);
        return this;
    }

    public final J4pClientBuilder expectContinue(boolean pUse) {
        HttpProtocolParams.setUseExpectContinue((HttpParams)this.params, (boolean)pUse);
        return this;
    }

    public final J4pClientBuilder tcpNoDelay(boolean pUse) {
        HttpConnectionParams.setTcpNoDelay((HttpParams)this.params, (boolean)pUse);
        return this;
    }

    public final J4pClientBuilder socketBufferSize(int pSize) {
        HttpConnectionParams.setSocketBufferSize((HttpParams)this.params, (int)pSize);
        return this;
    }

    public J4pClient build() {
        ClientConnectionManager cm = this.createClientConnectionManager();
        DefaultHttpClient httpClient = new DefaultHttpClient(cm, this.getHttpParams());
        if (this.user != null) {
            httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.user, this.password));
        }
        return new J4pClient(this.url, (HttpClient)httpClient, this.targetUrl != null ? new J4pTargetConfig(this.targetUrl, this.targetUser, this.targetPassword) : null);
    }

    ClientConnectionManager createClientConnectionManager() {
        return this.pooledConnections ? new ThreadSafeClientConnManager(this.getHttpParams(), this.getSchemeRegistry()) : new SingleClientConnManager(this.getSchemeRegistry());
    }

    HttpParams getHttpParams() {
        return this.params;
    }

    private SchemeRegistry getSchemeRegistry() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        return schemeRegistry;
    }
}

