/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import org.jolokia.server.core.backend.BackendManager;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.request.EmptyResponseException;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.request.JolokiaRequestFactory;
import org.jolokia.server.core.request.ProcessingParameters;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class HttpRequestHandler {
    private final BackendManager backendManager;
    private final JolokiaContext jolokiaCtx;
    public static final String PATH_QUERY_PARAM = "p";
    private static final Pattern PATH_PREFIX_PATTERN = Pattern.compile("^/?[^/]+/");

    public HttpRequestHandler(JolokiaContext pJolokiaCtx) {
        this.backendManager = new BackendManager(pJolokiaCtx);
        this.jolokiaCtx = pJolokiaCtx;
    }

    public JSONAware handleGetRequest(String pUri, String pPathInfo, Map<String, String[]> pParameterMap) throws EmptyResponseException {
        String pathInfo = this.extractPathInfo(pUri, pPathInfo);
        Object jmxReq = JolokiaRequestFactory.createGetRequest(pathInfo, this.getProcessingParameter(pParameterMap));
        if (this.jolokiaCtx.isDebug()) {
            this.jolokiaCtx.debug("URI: " + pUri);
            this.jolokiaCtx.debug("Path-Info: " + pathInfo);
            this.jolokiaCtx.debug("Request: " + jmxReq.toString());
        }
        return this.executeRequest((JolokiaRequest)jmxReq);
    }

    private ProcessingParameters getProcessingParameter(Map<String, String[]> pParameterMap) {
        HashMap<ConfigKey, String> config = new HashMap<ConfigKey, String>();
        if (pParameterMap != null) {
            this.extractRequestParameters(config, pParameterMap);
            this.extractDefaultRequestParameters(config);
        }
        return new ProcessingParameters(config);
    }

    public JSONAware handlePostRequest(String pUri, InputStream pInputStream, String pEncoding, Map<String, String[]> pParameterMap) throws IOException, EmptyResponseException {
        Object jsonRequest;
        if (this.jolokiaCtx.isDebug()) {
            this.jolokiaCtx.debug("URI: " + pUri);
        }
        if ((jsonRequest = this.extractJsonRequest(pInputStream, pEncoding)) instanceof JSONArray) {
            List<JolokiaRequest> jolokiaRequests = JolokiaRequestFactory.createPostRequests((List)jsonRequest, this.getProcessingParameter(pParameterMap));
            JSONArray responseList = new JSONArray();
            for (JolokiaRequest jmxReq : jolokiaRequests) {
                if (this.jolokiaCtx.isDebug()) {
                    this.jolokiaCtx.debug("Request: " + jmxReq.toString());
                }
                JSONObject resp = this.executeRequest(jmxReq);
                responseList.add((Object)resp);
            }
            return responseList;
        }
        if (jsonRequest instanceof JSONObject) {
            Object jmxReq = JolokiaRequestFactory.createPostRequest((Map)jsonRequest, this.getProcessingParameter(pParameterMap));
            return this.executeRequest((JolokiaRequest)jmxReq);
        }
        throw new IllegalArgumentException("Invalid JSON Request " + jsonRequest);
    }

    public Map<String, String> handleCorsPreflightRequest(String pOrigin, String pRequestHeaders) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (this.jolokiaCtx.isOriginAllowed(pOrigin, false)) {
            ret.put("Access-Control-Allow-Origin", pOrigin == null || "null".equals(pOrigin) ? "*" : pOrigin);
            if (pRequestHeaders != null) {
                ret.put("Access-Control-Allow-Headers", pRequestHeaders);
            }
            ret.put("Access-Control-Allow-Credentials", "true");
            ret.put("Access-Control-Max-Age", "31536000");
        }
        return ret;
    }

    private Object extractJsonRequest(InputStream pInputStream, String pEncoding) throws IOException {
        InputStreamReader reader = null;
        try {
            reader = pEncoding != null ? new InputStreamReader(pInputStream, pEncoding) : new InputStreamReader(pInputStream);
            JSONParser parser = new JSONParser();
            return parser.parse((Reader)reader);
        }
        catch (ParseException exp) {
            throw new IllegalArgumentException("Invalid JSON request " + reader, exp);
        }
    }

    private JSONObject executeRequest(JolokiaRequest pJmxReq) throws EmptyResponseException {
        try {
            return this.backendManager.handleRequest(pJmxReq);
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | ReflectionException e) {
            return this.getErrorJSON(404, e, pJmxReq);
        }
        catch (MBeanException e) {
            return this.getErrorJSON(500, e.getTargetException(), pJmxReq);
        }
        catch (IOException | UnsupportedOperationException | JMException e) {
            return this.getErrorJSON(500, e, pJmxReq);
        }
        catch (IllegalArgumentException e) {
            return this.getErrorJSON(400, e, pJmxReq);
        }
        catch (SecurityException e) {
            return this.getErrorJSON(403, new Exception(e.getMessage()), pJmxReq);
        }
        catch (RuntimeMBeanException e) {
            return this.errorForUnwrappedException(e, pJmxReq);
        }
    }

    public JSONObject handleThrowable(Throwable pThrowable) {
        if (pThrowable instanceof IllegalArgumentException) {
            return this.getErrorJSON(400, pThrowable, null);
        }
        if (pThrowable instanceof SecurityException) {
            return this.getErrorJSON(403, new Exception(pThrowable.getMessage()), null);
        }
        return this.getErrorJSON(500, pThrowable, null);
    }

    public JSONObject getErrorJSON(int pErrorCode, Throwable pExp, JolokiaRequest pJmxReq) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"status", (Object)pErrorCode);
        jsonObject.put((Object)"error", (Object)this.getExceptionMessage(pExp));
        jsonObject.put((Object)"error_type", (Object)pExp.getClass().getName());
        this.addErrorInfo(jsonObject, pExp, pJmxReq);
        if (this.jolokiaCtx.isDebug()) {
            this.jolokiaCtx.error("Error " + pErrorCode, pExp);
        }
        if (pJmxReq != null) {
            jsonObject.put((Object)"request", (Object)pJmxReq.toJSON());
        }
        return jsonObject;
    }

    public void checkAccess(String pRequestScheme, String pHost, String pAddress, String pOrigin) {
        String[] stringArray;
        if (pHost != null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = pHost;
            stringArray = stringArray2;
            stringArray2[1] = pAddress;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = pAddress;
        }
        if (!this.jolokiaCtx.isRemoteAccessAllowed(stringArray)) {
            throw new SecurityException("No access from client " + pAddress + " allowed");
        }
        if (!this.jolokiaCtx.isOriginAllowed(pOrigin, true)) {
            throw new SecurityException("Origin " + pOrigin + " is not allowed to call this agent");
        }
        if ("http".equals(pRequestScheme) && pOrigin != null && !"null".equals(pOrigin)) {
            try {
                String originScheme = new URL(pOrigin).getProtocol();
                if ("https".equals(originScheme)) {
                    throw new SecurityException("Secure origin " + pOrigin + " should not be processed over HTTP");
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public String extractCorsOrigin(String pOrigin) {
        if (pOrigin != null) {
            String origin = pOrigin.replaceAll("[\\n\\r]*", "");
            if (this.jolokiaCtx.isOriginAllowed(origin, false)) {
                return "null".equals(origin) ? "*" : origin;
            }
            return null;
        }
        return null;
    }

    private void extractRequestParameters(Map<ConfigKey, String> pConfig, Map<String, String[]> pParameterMap) {
        for (Map.Entry<String, String[]> entry : pParameterMap.entrySet()) {
            ConfigKey cKey;
            String[] values = entry.getValue();
            if (values == null || values.length <= 0 || (cKey = ConfigKey.getRequestConfigKey(entry.getKey())) == null) continue;
            String value = values[0];
            pConfig.put(cKey, value != null ? value.toString() : null);
        }
    }

    private void extractDefaultRequestParameters(Map<ConfigKey, String> pConfig) {
        Set<ConfigKey> globalRequestConfigKeys = this.jolokiaCtx.getConfigKeys();
        for (ConfigKey key : globalRequestConfigKeys) {
            if (!key.isRequestConfig() || pConfig.containsKey((Object)key)) continue;
            pConfig.put(key, this.jolokiaCtx.getConfig(key));
        }
    }

    private void addErrorInfo(JSONObject pErrorResp, Throwable pExp, JolokiaRequest pJmxReq) {
        if (Boolean.parseBoolean(this.jolokiaCtx.getConfig(ConfigKey.ALLOW_ERROR_DETAILS))) {
            String includeStackTrace;
            String string = includeStackTrace = pJmxReq != null ? pJmxReq.getParameter(ConfigKey.INCLUDE_STACKTRACE) : "false";
            if (includeStackTrace.equalsIgnoreCase("true") || includeStackTrace.equalsIgnoreCase("runtime") && pExp instanceof RuntimeException) {
                StringWriter writer = new StringWriter();
                pExp.printStackTrace(new PrintWriter(writer));
                pErrorResp.put((Object)"stacktrace", (Object)writer.toString());
            }
            if (pJmxReq != null && pJmxReq.getParameterAsBool(ConfigKey.SERIALIZE_EXCEPTION).booleanValue()) {
                pErrorResp.put((Object)"error_value", this.backendManager.convertExceptionToJson(pExp, pJmxReq));
            }
        }
    }

    private String getExceptionMessage(Throwable pException) {
        String message = pException.getLocalizedMessage();
        return pException.getClass().getName() + (String)(message != null ? " : " + message : "");
    }

    private JSONObject errorForUnwrappedException(Exception e, JolokiaRequest pJmxReq) {
        Throwable cause = e.getCause();
        int code = cause instanceof IllegalArgumentException ? 400 : (cause instanceof SecurityException ? 403 : 500);
        return this.getErrorJSON(code, cause, pJmxReq);
    }

    private String extractPathInfo(String pUri, String pPathInfo) {
        Matcher matcher;
        if (pUri.contains("!//") && (matcher = PATH_PREFIX_PATTERN.matcher(pPathInfo)).find()) {
            String prefix = matcher.group();
            String pathInfoEncoded = pUri.replaceFirst("^.*?" + prefix, prefix);
            return URLDecoder.decode(pathInfoEncoded, StandardCharsets.UTF_8);
        }
        return pPathInfo;
    }
}

