/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.request;

import java.util.HashMap;
import java.util.Map;
import org.jolokia.server.core.config.ConfigKey;

public class ProcessingParameters {
    private final Map<ConfigKey, String> params;

    public ProcessingParameters(Map<ConfigKey, String> pConfig) {
        this.params = pConfig;
    }

    public String get(ConfigKey pKey) {
        String value = this.params.get((Object)pKey);
        if (value != null) {
            return value;
        }
        return pKey.getDefaultValue();
    }

    public ProcessingParameters mergedParams(Map<String, String> pConfig) {
        if (pConfig == null) {
            return this;
        }
        HashMap<ConfigKey, String> newParams = new HashMap<ConfigKey, String>();
        newParams.putAll(this.params);
        newParams.putAll(this.convertToConfigMap(pConfig));
        return new ProcessingParameters(newParams);
    }

    public String getPathInfo() {
        return this.params.get((Object)ConfigKey.PATH_QUERY_PARAM);
    }

    private Map<ConfigKey, String> convertToConfigMap(Map<String, String> pParams) {
        HashMap<ConfigKey, String> config = new HashMap<ConfigKey, String>();
        if (pParams != null) {
            for (Map.Entry<String, String> entry : pParams.entrySet()) {
                ConfigKey cKey = ConfigKey.getRequestConfigKey(entry.getKey());
                if (cKey == null) continue;
                String value = entry.getValue();
                config.put(cKey, value != null ? value.toString() : null);
            }
        }
        return config;
    }
}

