/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.config;

import java.util.HashMap;
import java.util.Map;

public enum ConfigKey {
    HISTORY_MAX_ENTRIES("historyMaxEntries", true, false, "10"),
    DEBUG("debug", true, false, "false"),
    DEBUG_MAX_ENTRIES("debugMaxEntries", true, false, "100"),
    JSR160_PROXY_ALLOWED_TARGETS("jsr160ProxyAllowedTargets", true, false),
    LOGHANDLER_CLASS("logHandlerClass", true, false),
    LOGHANDLER_NAME("logHandlerName", true, false, "org.jolokia"),
    MAX_DEPTH("maxDepth", true, true),
    MAX_COLLECTION_SIZE("maxCollectionSize", true, true),
    MAX_OBJECTS("maxObjects", true, true),
    SERIALIZE_LONG("serializeLong", true, true),
    RESTRICTOR_CLASS("restrictorClass", true, false),
    POLICY_LOCATION("policyLocation", true, false, "classpath:/jolokia-access.xml"),
    ALLOW_DNS_REVERSE_LOOKUP("allowDnsReverseLookup", true, false, "false"),
    IGNORE_ERRORS("ignoreErrors", false, true),
    INCLUDE_STACKTRACE("includeStackTrace", true, true, "false"),
    SERIALIZE_EXCEPTION("serializeException", true, true, "false"),
    ALLOW_ERROR_DETAILS("allowErrorDetails", true, false, "true"),
    CANONICAL_NAMING("canonicalNaming", true, true, "true"),
    STREAMING("streaming", true, false, "true"),
    MBEAN_QUALIFIER("mbeanQualifier", true, false),
    CALLBACK("callback", false, true),
    MIME_TYPE("mimeType", true, true, "text/plain"),
    IF_MODIFIED_SINCE("ifModifiedSince", false, true),
    PATH_QUERY_PARAM("p", false, true),
    DISCOVERY_ENABLED("discoveryEnabled", true, false, "false"),
    DISCOVERY_AGENT_URL("discoveryAgentUrl", true, false),
    MULTICAST_GROUP("multicastGroup", true, false, "239.192.48.84"),
    MULTICAST_PORT("multicastPort", true, false, "24884"),
    USER("user", true, false),
    PASSWORD("password", true, false),
    REALM("realm", true, false, "jolokia"),
    AUTH_MODE("authMode", true, false, "basic"),
    AUTH_MATCH("authMatch", true, false, "any"),
    AUTH_CLASS("authClass", true, false),
    AUTH_URL("authUrl", true, false),
    AUTH_PRINCIPAL_SPEC("authPrincipalSpec", true, false),
    AUTH_IGNORE_CERTS("authIgnoreCerts", true, false, "false"),
    AGENT_CONTEXT("agentContext", true, false, "/jolokia"),
    USE_RESTRICTOR_SERVICE("useRestrictorService", true, false, "false"),
    LISTEN_FOR_HTTP_SERVICE("listenForHttpService", true, false),
    REGISTER_WHITEBOARD_SERVLET("registerWhiteboardServlet", true, false, "true"),
    HTTP_SERVICE_FILTER("httpServiceFilter", true, false),
    DETECTOR_OPTIONS("detectorOptions", true, false),
    AGENT_ID("agentId", true, false),
    AGENT_TYPE("agentType", true, false),
    AGENT_DESCRIPTION("agentDescription", true, false);

    public static final String JAAS_SUBJECT_REQUEST_ATTRIBUTE = "org.jolokia.jaasSubject";
    private final String key;
    private final String defaultValue;
    private final boolean globalConfig;
    private final boolean requestConfig;
    private static final Map<String, ConfigKey> keyByName;
    private static final Map<String, ConfigKey> globalKeyByName;
    private static final Map<String, ConfigKey> requestKeyByName;

    private ConfigKey(String pValue, boolean pIsGlobalConfig, boolean pIsRequestConfig) {
        this(pValue, pIsGlobalConfig, pIsRequestConfig, null);
    }

    private ConfigKey(String pValue, boolean pIsGlobalConfig, boolean pIsRequestConfig, String pDefault) {
        this.key = pValue;
        this.defaultValue = pDefault;
        this.globalConfig = pIsGlobalConfig;
        this.requestConfig = pIsRequestConfig;
    }

    public String toString() {
        return this.key;
    }

    public static ConfigKey getGlobalConfigKey(String pKeyS) {
        return globalKeyByName.get(pKeyS);
    }

    public static ConfigKey getRequestConfigKey(String pKeyS) {
        return requestKeyByName.get(pKeyS);
    }

    public String getKeyValue() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isGlobalConfig() {
        return this.globalConfig;
    }

    public boolean isRequestConfig() {
        return this.requestConfig;
    }

    public String asSystemProperty() {
        return "jolokia." + this.getKeyValue();
    }

    public String asEnvVariable() {
        String kevValue = this.getKeyValue();
        StringBuilder buf = new StringBuilder();
        boolean notFirst = false;
        for (char c : kevValue.toCharArray()) {
            if (Character.isUpperCase(c) && notFirst) {
                buf.append("_").append(c);
            } else {
                buf.append(Character.toUpperCase(c));
            }
            notFirst = true;
        }
        return "JOLOKIA_" + buf;
    }

    static {
        keyByName = new HashMap<String, ConfigKey>();
        globalKeyByName = new HashMap<String, ConfigKey>();
        requestKeyByName = new HashMap<String, ConfigKey>();
        for (ConfigKey ck : ConfigKey.values()) {
            keyByName.put(ck.getKeyValue(), ck);
            if (ck.isGlobalConfig()) {
                globalKeyByName.put(ck.getKeyValue(), ck);
            }
            if (!ck.isRequestConfig()) continue;
            requestKeyByName.put(ck.getKeyValue(), ck);
        }
    }

    private static class Constants {
        public static final String FALSE = "false";
        public static final String TRUE = "true";

        private Constants() {
        }
    }
}

