/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.config;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jolokia.server.core.config.ConfigExtractor;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.config.Configuration;

public class StaticConfiguration
implements Configuration {
    private final Map<ConfigKey, String> configMap;

    public StaticConfiguration(Object ... keyAndValues) {
        int idx = 0;
        this.configMap = new HashMap<ConfigKey, String>();
        for (int i = idx; i < keyAndValues.length; i += 2) {
            this.configMap.put((ConfigKey)((Object)keyAndValues[i]), (String)keyAndValues[i + 1]);
        }
    }

    public StaticConfiguration(Map<String, String> pConfig) {
        this.configMap = new HashMap<ConfigKey, String>();
        for (ConfigKey c : ConfigKey.values()) {
            String value = pConfig.get(c.getKeyValue());
            if (value == null) continue;
            this.configMap.put(c, value);
        }
    }

    public void update(ConfigExtractor pExtractor) {
        Enumeration<String> e = pExtractor.getNames();
        while (e.hasMoreElements()) {
            String keyS = e.nextElement();
            ConfigKey key = ConfigKey.getGlobalConfigKey(keyS);
            if (key == null) continue;
            this.configMap.put(key, pExtractor.getParameter(keyS));
        }
    }

    public void update(Configuration pConfig) {
        for (ConfigKey key : pConfig.getConfigKeys()) {
            this.configMap.put(key, pConfig.getConfig(key));
        }
    }

    @Override
    public String getConfig(ConfigKey pKey) {
        return this.getConfig(pKey, false);
    }

    @Override
    public String getConfig(ConfigKey pKey, boolean checkSysOrEnv) {
        String value;
        if (checkSysOrEnv) {
            String property = System.getProperty(pKey.asSystemProperty());
            if (property != null) {
                return property;
            }
            property = System.getenv(pKey.asEnvVariable());
            if (property != null) {
                return property;
            }
        }
        if ((value = this.configMap.get((Object)pKey)) == null) {
            value = pKey.getDefaultValue();
        }
        return value;
    }

    @Override
    public Set<ConfigKey> getConfigKeys() {
        return this.configMap.keySet();
    }

    @Override
    public boolean containsKey(ConfigKey pKey) {
        return this.configMap.containsKey((Object)pKey);
    }
}

