/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.request.notification;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jolokia.server.core.request.notification.ClientCommand;
import org.jolokia.server.core.request.notification.NotificationCommandType;
import org.jolokia.server.core.util.EscapeUtil;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class AddCommand
extends ClientCommand {
    private final ObjectName objectName;
    private final String mode;
    private Map<String, Object> config;
    private List<String> filter;
    private Object handback;

    AddCommand(Stack<String> pStack) throws MalformedObjectNameException {
        super(NotificationCommandType.ADD, pStack);
        String element;
        if (pStack.isEmpty()) {
            throw new IllegalArgumentException("No mode give for " + NotificationCommandType.ADD);
        }
        this.mode = pStack.pop();
        if (pStack.isEmpty()) {
            throw new IllegalArgumentException("No MBean name given for " + NotificationCommandType.ADD);
        }
        this.objectName = new ObjectName(pStack.pop());
        if (!pStack.isEmpty() && !(element = pStack.pop()).trim().isEmpty()) {
            this.filter = EscapeUtil.split(element, "\\\\", ",");
        }
        if (!pStack.isEmpty()) {
            this.config = this.parseConfig(pStack.pop());
        }
        if (!pStack.isEmpty()) {
            this.handback = pStack.pop();
        }
    }

    AddCommand(Map<String, ?> pMap) throws MalformedObjectNameException {
        super(NotificationCommandType.ADD, pMap);
        Object c;
        if (!pMap.containsKey("mode")) {
            throw new IllegalArgumentException("No mode give for " + NotificationCommandType.ADD);
        }
        this.mode = (String)pMap.get("mode");
        if (!pMap.containsKey("mbean")) {
            throw new IllegalArgumentException("No MBean name given for " + NotificationCommandType.ADD);
        }
        this.objectName = new ObjectName((String)pMap.get("mbean"));
        Object f = pMap.get("filter");
        if (f != null) {
            List<String> list = this.filter = f instanceof List ? (List<String>)f : Collections.singletonList(f.toString());
        }
        if ((c = pMap.get("config")) != null) {
            this.config = c instanceof Map ? (Map<String, Object>)c : this.parseConfig(c.toString());
        }
        this.handback = pMap.get("handback");
    }

    public String getMode() {
        return this.mode;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public List<String> getFilter() {
        return this.filter;
    }

    public Object getHandback() {
        return this.handback;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject ret = super.toJSON();
        ret.put((Object)"mbean", (Object)this.objectName.toString());
        ret.put((Object)"mode", (Object)this.mode);
        if (this.filter != null && !this.filter.isEmpty()) {
            ret.put((Object)"filter", this.filter);
        }
        if (this.config != null && !this.config.isEmpty()) {
            ret.put((Object)"config", this.config);
        }
        if (this.handback != null) {
            ret.put((Object)"handback", this.handback);
        }
        return ret;
    }

    private Map<String, Object> parseConfig(String pElement) {
        try {
            return (Map)new JSONParser().parse(pElement);
        }
        catch (ClassCastException | ParseException e) {
            throw new IllegalArgumentException("Cannot parse config '" + pElement + "' as JSON Object", e);
        }
    }
}

