/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.support.spring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.jolokia.jvmagent.JolokiaServer;
import org.jolokia.jvmagent.JolokiaServerConfig;
import org.jolokia.server.core.service.api.JolokiaService;
import org.jolokia.server.core.service.api.LogHandler;
import org.jolokia.support.spring.SpringJolokiaConfigHolder;
import org.jolokia.support.spring.SpringJolokiaLogHandlerHolder;
import org.jolokia.support.spring.SystemPropertyMode;
import org.jolokia.support.spring.backend.SpringRequestHandler;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.OrderComparator;

public class SpringJolokiaAgent
extends JolokiaServer
implements ApplicationContextAware,
InitializingBean,
DisposableBean {
    private SpringJolokiaConfigHolder configHolder;
    private boolean lookupConfig = false;
    private boolean lookupServices = false;
    private boolean exposeApplicationContext = false;
    private SystemPropertyMode systemPropertyMode;
    private ApplicationContext context;
    private SpringJolokiaLogHandlerHolder logHandlerHolder;

    public void afterPropertiesSet() throws IOException {
        HashMap<String, String> config = new HashMap<String, String>();
        if (this.systemPropertyMode == SystemPropertyMode.FALLBACK) {
            config.putAll(this.lookupSystemProperties());
        }
        if (this.configHolder.getConfig() != null) {
            config.putAll(this.configHolder.getConfig());
        }
        if (this.lookupConfig && this.context != null) {
            config.putAll(this.lookupConfigurationFromContext());
        }
        if (this.systemPropertyMode == SystemPropertyMode.OVERRIDE) {
            config.putAll(this.lookupSystemProperties());
        }
        boolean autoStart = Boolean.parseBoolean((String)config.remove("autoStart"));
        LogHandler logHandler = this.logHandlerHolder != null ? this.logHandlerHolder.getLogHandler() : null;
        this.init(new JolokiaServerConfig(config), logHandler);
        if (this.exposeApplicationContext && this.context != null) {
            this.addService((JolokiaService)new SpringRequestHandler(this.context, 100));
        }
        if (this.lookupServices) {
            this.lookupServices();
        }
        if (autoStart) {
            this.start();
        }
    }

    private void lookupServices() {
        Map services = this.context.getBeansOfType(JolokiaService.class);
        for (JolokiaService service : services.values()) {
            this.addService(service);
        }
    }

    private Map<String, String> lookupConfigurationFromContext() {
        HashMap<String, String> config = new HashMap<String, String>();
        Map configsMap = this.context.getBeansOfType(SpringJolokiaConfigHolder.class);
        ArrayList configs = new ArrayList(configsMap.values());
        configs.sort(new OrderComparator());
        for (SpringJolokiaConfigHolder c : configs) {
            if (c == this.configHolder) continue;
            config.putAll(c.getConfig());
        }
        return config;
    }

    private Map<String, String> lookupSystemProperties() {
        HashMap<String, String> ret = new HashMap<String, String>();
        Enumeration<?> propEnum = System.getProperties().propertyNames();
        while (propEnum.hasMoreElements()) {
            String prop = (String)propEnum.nextElement();
            if (!prop.startsWith("jolokia.")) continue;
            String key = prop.substring("jolokia.".length());
            ret.put(key, System.getProperty(prop));
        }
        return ret;
    }

    public void destroy() {
        this.stop();
    }

    public void setConfig(SpringJolokiaConfigHolder pConfig) {
        this.configHolder = pConfig;
    }

    public void setLogHandler(SpringJolokiaLogHandlerHolder pLogHandlerHolder) {
        this.logHandlerHolder = pLogHandlerHolder;
    }

    public void setLookupConfig(boolean pLookupConfig) {
        this.lookupConfig = pLookupConfig;
    }

    public void setExposeApplicationContext(boolean pExposeApplicationContext) {
        this.exposeApplicationContext = pExposeApplicationContext;
    }

    public void setLookupServices(boolean pLookupServices) {
        this.lookupServices = pLookupServices;
    }

    public void setApplicationContext(ApplicationContext pContext) {
        this.context = pContext;
    }

    public void setSystemPropertiesMode(String pMode) {
        this.systemPropertyMode = SystemPropertyMode.fromMode(pMode);
        if (this.systemPropertyMode == null) {
            this.systemPropertyMode = SystemPropertyMode.NEVER;
        }
    }

    public void setId(String pId) {
    }
}

