/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.springmvc.scanner.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jsondoc.core.pojo.ApiHeaderDoc;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;

public class SpringHeaderBuilder {
    public static Set<ApiHeaderDoc> buildHeaders(Method method) {
        List<String> headersStringList;
        LinkedHashSet<ApiHeaderDoc> headers = new LinkedHashSet<ApiHeaderDoc>();
        Class<?> controller = method.getDeclaringClass();
        RequestMapping typeAnnotation = controller.getAnnotation(RequestMapping.class);
        RequestMapping methodAnnotation = method.getAnnotation(RequestMapping.class);
        if (typeAnnotation != null) {
            headersStringList = Arrays.asList(typeAnnotation.headers());
            SpringHeaderBuilder.addToHeaders(headers, headersStringList);
        }
        if (methodAnnotation != null) {
            headersStringList = Arrays.asList(methodAnnotation.headers());
            SpringHeaderBuilder.addToHeaders(headers, headersStringList);
        }
        Annotation[][] parametersAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parametersAnnotations.length; ++i) {
            for (int j = 0; j < parametersAnnotations[i].length; ++j) {
                String[] stringArray;
                if (!(parametersAnnotations[i][j] instanceof RequestHeader)) continue;
                RequestHeader requestHeader = (RequestHeader)parametersAnnotations[i][j];
                String string = requestHeader.value();
                if (requestHeader.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n")) {
                    stringArray = new String[]{};
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = requestHeader.defaultValue();
                }
                headers.add(new ApiHeaderDoc(string, "", stringArray));
            }
        }
        return headers;
    }

    private static void addToHeaders(Set<ApiHeaderDoc> headers, List<String> headersStringList) {
        for (String header : headersStringList) {
            String[] splitHeader = header.split("=");
            if (splitHeader.length > 1) {
                headers.add(new ApiHeaderDoc(splitHeader[0], null, new String[]{splitHeader[1]}));
                continue;
            }
            headers.add(new ApiHeaderDoc(splitHeader[0], null, new String[0]));
        }
    }
}

