/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine;

import java.util.List;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;
import org.junit.jupiter.engine.descriptor.NestedClassTestDescriptor;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.discovery.ClassFilter;

class DiscoveryFilterApplier {
    DiscoveryFilterApplier() {
    }

    void applyAllFilters(EngineDiscoveryRequest discoveryRequest, TestDescriptor engineDescriptor) {
        this.applyClassFilters(discoveryRequest.getDiscoveryFiltersByType(ClassFilter.class), engineDescriptor);
    }

    private void applyClassFilters(List<ClassFilter> classFilters, TestDescriptor engineDescriptor) {
        if (classFilters.isEmpty()) {
            return;
        }
        TestDescriptor.Visitor filteringVisitor = descriptor -> {
            if (descriptor instanceof ClassTestDescriptor && !this.includeClass((ClassTestDescriptor)descriptor, classFilters)) {
                descriptor.removeFromHierarchy();
            }
        };
        engineDescriptor.accept(filteringVisitor);
    }

    private boolean includeClass(ClassTestDescriptor classTestDescriptor, List<ClassFilter> classFilters) {
        if (classTestDescriptor instanceof NestedClassTestDescriptor) {
            return true;
        }
        Class<?> testClass = classTestDescriptor.getTestClass();
        return classFilters.stream().map(filter -> filter.apply((Object)testClass)).noneMatch(FilterResult::excluded);
    }
}

