/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.util.Arrays;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvFormat;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvParser;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvParserSettings;
import org.junit.jupiter.params.support.AnnotationConsumer;

class CsvArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<CsvSource> {
    private String[] lines;
    private char delimiter;

    CsvArgumentsProvider() {
    }

    @Override
    public void accept(CsvSource annotation) {
        this.lines = annotation.value();
        this.delimiter = annotation.delimiter();
    }

    @Override
    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        CsvParserSettings settings = new CsvParserSettings();
        ((CsvFormat)settings.getFormat()).setDelimiter(this.delimiter);
        ((CsvFormat)settings.getFormat()).setQuote('\'');
        ((CsvFormat)settings.getFormat()).setQuoteEscape('\'');
        settings.setAutoConfigurationEnabled(false);
        CsvParser csvParser = new CsvParser(settings);
        return Arrays.stream(this.lines).map(csvParser::parseLine).map(Arguments::of);
    }
}

