/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.params.ParameterizedTestMethodContext;

class ParameterizedTestParameterResolver
implements ParameterResolver {
    private final ParameterizedTestMethodContext methodContext;
    private final Object[] arguments;

    ParameterizedTestParameterResolver(ParameterizedTestMethodContext methodContext, Object[] arguments) {
        this.methodContext = methodContext;
        this.arguments = arguments;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Executable declaringExecutable = parameterContext.getDeclaringExecutable();
        Method testMethod = extensionContext.getTestMethod().orElse(null);
        int parameterIndex = parameterContext.getIndex();
        if (!declaringExecutable.equals(testMethod)) {
            return false;
        }
        if (this.methodContext.isAggregator(parameterIndex)) {
            return true;
        }
        if (this.methodContext.hasAggregator()) {
            return parameterIndex < this.methodContext.indexOfFirstAggregator();
        }
        return parameterIndex < this.arguments.length;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.methodContext.resolve(parameterContext, this.extractPayloads(this.arguments));
    }

    private Object[] extractPayloads(Object[] arguments) {
        return Arrays.stream(arguments).map(argument -> {
            if (argument instanceof Named) {
                return ((Named)argument).getPayload();
            }
            return argument;
        }).toArray();
    }
}

