/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.consumer.invoker;

import java.util.List;
import java.util.Map;
import org.jupiter.common.util.Maps;
import org.jupiter.rpc.consumer.cluster.ClusterInvoker;
import org.jupiter.rpc.consumer.cluster.FailFastClusterInvoker;
import org.jupiter.rpc.consumer.cluster.FailOverClusterInvoker;
import org.jupiter.rpc.consumer.cluster.FailSafeClusterInvoker;
import org.jupiter.rpc.consumer.dispatcher.Dispatcher;
import org.jupiter.rpc.model.metadata.ClusterStrategyConfig;
import org.jupiter.rpc.model.metadata.MethodSpecialConfig;

public class ClusterStrategyBridging {
    private final ClusterInvoker defaultClusterInvoker;
    private final Map<String, ClusterInvoker> methodSpecialClusterInvokerMapping;

    public ClusterStrategyBridging(Dispatcher dispatcher, ClusterStrategyConfig defaultStrategy, List<MethodSpecialConfig> methodSpecialConfigs) {
        this.defaultClusterInvoker = this.createClusterInvoker(dispatcher, defaultStrategy);
        this.methodSpecialClusterInvokerMapping = Maps.newHashMap();
        for (MethodSpecialConfig config : methodSpecialConfigs) {
            ClusterStrategyConfig strategy = config.getStrategy();
            if (strategy == null) continue;
            this.methodSpecialClusterInvokerMapping.put(config.getMethodName(), this.createClusterInvoker(dispatcher, strategy));
        }
    }

    public ClusterInvoker findClusterInvoker(String methodName) {
        ClusterInvoker invoker = this.methodSpecialClusterInvokerMapping.get(methodName);
        return invoker != null ? invoker : this.defaultClusterInvoker;
    }

    private ClusterInvoker createClusterInvoker(Dispatcher dispatcher, ClusterStrategyConfig strategy) {
        ClusterInvoker.Strategy s = strategy.getStrategy();
        switch (s) {
            case FAIL_FAST: {
                return new FailFastClusterInvoker(dispatcher);
            }
            case FAIL_OVER: {
                return new FailOverClusterInvoker(dispatcher, strategy.getFailoverRetries());
            }
            case FAIL_SAFE: {
                return new FailSafeClusterInvoker(dispatcher);
            }
        }
        throw new UnsupportedOperationException("strategy: " + strategy);
    }
}

