/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jupiter.common.util.ClassUtil;
import org.jupiter.common.util.ExceptionUtil;
import org.jupiter.common.util.JServiceLoader;
import org.jupiter.common.util.Preconditions;
import org.jupiter.common.util.Strings;
import org.jupiter.registry.AbstractRegistryService;
import org.jupiter.registry.NotifyListener;
import org.jupiter.registry.OfflineListener;
import org.jupiter.registry.RegisterMeta;
import org.jupiter.registry.RegistryService;
import org.jupiter.rpc.JClient;
import org.jupiter.rpc.ServiceProvider;
import org.jupiter.rpc.consumer.processor.DefaultConsumerProcessor;
import org.jupiter.rpc.model.metadata.ServiceMetadata;
import org.jupiter.transport.Directory;
import org.jupiter.transport.JConnection;
import org.jupiter.transport.JConnectionManager;
import org.jupiter.transport.JConnector;
import org.jupiter.transport.UnresolvedAddress;
import org.jupiter.transport.channel.JChannelGroup;
import org.jupiter.transport.processor.ConsumerProcessor;

public class DefaultClient
implements JClient {
    private final RegistryService registryService;
    private final String appName;
    private JConnector<JConnection> connector;

    public DefaultClient() {
        this("UNKNOWN", RegistryService.RegistryType.DEFAULT);
    }

    public DefaultClient(RegistryService.RegistryType registryType) {
        this("UNKNOWN", registryType);
    }

    public DefaultClient(String appName) {
        this(appName, RegistryService.RegistryType.DEFAULT);
    }

    public DefaultClient(String appName, RegistryService.RegistryType registryType) {
        this.appName = Strings.isBlank((String)appName) ? "UNKNOWN" : appName;
        registryType = registryType == null ? RegistryService.RegistryType.DEFAULT : registryType;
        this.registryService = (RegistryService)JServiceLoader.load(RegistryService.class).find(registryType.getValue());
    }

    @Override
    public String appName() {
        return this.appName;
    }

    @Override
    public JConnector<JConnection> connector() {
        return this.connector;
    }

    @Override
    public JClient withConnector(JConnector<JConnection> connector) {
        if (connector.processor() == null) {
            connector.withProcessor((ConsumerProcessor)new DefaultConsumerProcessor());
        }
        this.connector = connector;
        return this;
    }

    @Override
    public RegistryService registryService() {
        return this.registryService;
    }

    @Override
    public Collection<RegisterMeta> lookup(Directory directory) {
        RegisterMeta.ServiceMeta serviceMeta = DefaultClient.toServiceMeta(directory);
        return this.registryService.lookup(serviceMeta);
    }

    @Override
    public JConnector.ConnectionWatcher watchConnections(Class<?> interfaceClass) {
        return this.watchConnections(interfaceClass, "1.0.0");
    }

    @Override
    public JConnector.ConnectionWatcher watchConnections(Class<?> interfaceClass, String version) {
        Preconditions.checkNotNull(interfaceClass, (Object)"interfaceClass");
        ServiceProvider annotation = interfaceClass.getAnnotation(ServiceProvider.class);
        Preconditions.checkNotNull((Object)annotation, (Object)(interfaceClass + " is not a ServiceProvider interface"));
        String providerName = annotation.name();
        providerName = Strings.isNotBlank((String)providerName) ? providerName : interfaceClass.getName();
        version = Strings.isNotBlank((String)version) ? version : "1.0.0";
        return this.watchConnections(new ServiceMetadata(annotation.group(), providerName, version));
    }

    @Override
    public JConnector.ConnectionWatcher watchConnections(final Directory directory) {
        JConnector.ConnectionWatcher manager = new JConnector.ConnectionWatcher(){
            private final JConnectionManager connectionManager;
            private final ReentrantLock lock;
            private final Condition notifyCondition;
            private final AtomicBoolean signalNeeded;
            {
                this.connectionManager = DefaultClient.this.connector.connectionManager();
                this.lock = new ReentrantLock();
                this.notifyCondition = this.lock.newCondition();
                this.signalNeeded = new AtomicBoolean(false);
            }

            public void start() {
                DefaultClient.this.subscribe(directory, new NotifyListener(){

                    public void notify(RegisterMeta registerMeta, NotifyListener.NotifyEvent event) {
                        UnresolvedAddress address = new UnresolvedAddress(registerMeta.getHost(), registerMeta.getPort());
                        final JChannelGroup group = DefaultClient.this.connector.group(address);
                        if (event == NotifyListener.NotifyEvent.CHILD_ADDED) {
                            if (!group.isAvailable()) {
                                JConnection[] connections;
                                for (JConnection c : connections = this.connectTo(address, group, registerMeta, true)) {
                                    c.operationComplete(new Runnable(){

                                        @Override
                                        public void run() {
                                            this.onSucceed(group, signalNeeded.getAndSet(false));
                                        }
                                    });
                                }
                            } else {
                                this.onSucceed(group, signalNeeded.getAndSet(false));
                            }
                            group.setWeight(directory, registerMeta.getWeight());
                        } else if (event == NotifyListener.NotifyEvent.CHILD_REMOVED) {
                            DefaultClient.this.connector.removeChannelGroup(directory, group);
                            group.removeWeight(directory);
                            if (DefaultClient.this.connector.directoryGroup().getRefCount(group) <= 0) {
                                connectionManager.cancelReconnect(address);
                            }
                        }
                    }

                    private JConnection[] connectTo(final UnresolvedAddress address, final JChannelGroup group, RegisterMeta registerMeta, boolean async) {
                        int connCount = registerMeta.getConnCount();
                        connCount = connCount < 1 ? 1 : connCount;
                        JConnection[] connections = new JConnection[connCount];
                        group.setCapacity(connCount);
                        for (int i = 0; i < connCount; ++i) {
                            JConnection connection;
                            connections[i] = connection = (JConnection)DefaultClient.this.connector.connect(address, async);
                            connectionManager.manage(connection);
                        }
                        DefaultClient.this.offlineListening(address, new OfflineListener(){

                            public void offline() {
                                connectionManager.cancelReconnect(address);
                                if (!group.isAvailable()) {
                                    DefaultClient.this.connector.removeChannelGroup(directory, group);
                                }
                            }
                        });
                        return connections;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void onSucceed(JChannelGroup group, boolean doSignal) {
                        DefaultClient.this.connector.addChannelGroup(directory, group);
                        if (doSignal) {
                            ReentrantLock _look = lock;
                            _look.lock();
                            try {
                                notifyCondition.signalAll();
                            }
                            finally {
                                _look.unlock();
                            }
                        }
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean waitForAvailable(long timeoutMillis) {
                if (DefaultClient.this.connector.isDirectoryAvailable(directory)) {
                    return true;
                }
                long remains = TimeUnit.MILLISECONDS.toNanos(timeoutMillis);
                boolean available = false;
                ReentrantLock _look = this.lock;
                _look.lock();
                try {
                    this.signalNeeded.set(true);
                    while (!(available = DefaultClient.this.connector.isDirectoryAvailable(directory)) && (remains = this.notifyCondition.awaitNanos(remains)) > 0L) {
                    }
                }
                catch (InterruptedException e) {
                    ExceptionUtil.throwException((Throwable)e);
                }
                finally {
                    _look.unlock();
                }
                return available || DefaultClient.this.connector.isDirectoryAvailable(directory);
            }
        };
        manager.start();
        return manager;
    }

    @Override
    public boolean awaitConnections(Class<?> interfaceClass, long timeoutMillis) {
        return this.awaitConnections(interfaceClass, "1.0.0", timeoutMillis);
    }

    @Override
    public boolean awaitConnections(Class<?> interfaceClass, String version, long timeoutMillis) {
        JConnector.ConnectionWatcher watcher = this.watchConnections(interfaceClass, version);
        return watcher.waitForAvailable(timeoutMillis);
    }

    @Override
    public boolean awaitConnections(Directory directory, long timeoutMillis) {
        JConnector.ConnectionWatcher watcher = this.watchConnections(directory);
        return watcher.waitForAvailable(timeoutMillis);
    }

    @Override
    public void subscribe(Directory directory, NotifyListener listener) {
        this.registryService.subscribe(DefaultClient.toServiceMeta(directory), listener);
    }

    @Override
    public void offlineListening(UnresolvedAddress address, OfflineListener listener) {
        if (!(this.registryService instanceof AbstractRegistryService)) {
            throw new UnsupportedOperationException();
        }
        ((AbstractRegistryService)this.registryService).offlineListening(DefaultClient.toAddress(address), listener);
    }

    @Override
    public void shutdownGracefully() {
        this.registryService.shutdownGracefully();
        this.connector.shutdownGracefully();
    }

    public void connectToRegistryServer(String connectString) {
        this.registryService.connectToRegistryServer(connectString);
    }

    public void setConnector(JConnector<JConnection> connector) {
        this.withConnector(connector);
    }

    private static RegisterMeta.ServiceMeta toServiceMeta(Directory directory) {
        RegisterMeta.ServiceMeta serviceMeta = new RegisterMeta.ServiceMeta();
        serviceMeta.setGroup((String)Preconditions.checkNotNull((Object)directory.getGroup(), (Object)"group"));
        serviceMeta.setServiceProviderName((String)Preconditions.checkNotNull((Object)directory.getServiceProviderName(), (Object)"serviceProviderName"));
        serviceMeta.setVersion((String)Preconditions.checkNotNull((Object)directory.getVersion(), (Object)"version"));
        return serviceMeta;
    }

    private static RegisterMeta.Address toAddress(UnresolvedAddress address) {
        return new RegisterMeta.Address(address.getHost(), address.getPort());
    }

    static {
        ClassUtil.classInitialize((String)"org.jupiter.rpc.tracing.TracingUtil", (long)500L);
    }
}

