/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.consumer.dispatcher;

import org.jupiter.rpc.DispatchType;
import org.jupiter.rpc.JClient;
import org.jupiter.rpc.JRequest;
import org.jupiter.rpc.OutputBufImpl;
import org.jupiter.rpc.consumer.dispatcher.AbstractDispatcher;
import org.jupiter.rpc.consumer.future.DefaultInvokeFuture;
import org.jupiter.rpc.consumer.future.InvokeFuture;
import org.jupiter.rpc.load.balance.LoadBalancer;
import org.jupiter.rpc.model.metadata.MessageWrapper;
import org.jupiter.serialization.OutputBuf;
import org.jupiter.serialization.Serializer;
import org.jupiter.serialization.SerializerType;
import org.jupiter.transport.LowCopy;
import org.jupiter.transport.channel.JChannel;

public class DefaultRoundDispatcher
extends AbstractDispatcher {
    public DefaultRoundDispatcher(JClient client, LoadBalancer loadBalancer, SerializerType serializerType) {
        super(client, loadBalancer, serializerType);
    }

    @Override
    public <T> InvokeFuture<T> dispatch(JRequest request, Class<T> returnType) {
        Serializer _serializer = this.serializer();
        MessageWrapper message = request.message();
        JChannel channel = this.select(message.getMetadata());
        byte s_code = _serializer.code();
        if (LowCopy.isEncodeLowCopy()) {
            OutputBuf outputBuf = _serializer.writeObject((OutputBuf)new OutputBufImpl(channel.allocOutput()), (Object)message);
            request.outputBuf(s_code, outputBuf);
        } else {
            byte[] bytes = _serializer.writeObject((Object)message);
            request.bytes(s_code, bytes);
        }
        long timeoutMillis = this.getMethodSpecialTimeoutMillis(message.getMethodName());
        DefaultInvokeFuture<T> future = DefaultInvokeFuture.with(request.invokeId(), channel, returnType, timeoutMillis, DispatchType.ROUND).interceptors(this.interceptors()).traceId(message.getTraceId());
        return DefaultRoundDispatcher.write(channel, request, future, DispatchType.ROUND);
    }
}

