/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.load.balance;

import java.util.concurrent.ThreadLocalRandom;
import org.jupiter.rpc.load.balance.AbstractLoadBalancer;
import org.jupiter.rpc.load.balance.WeightArray;
import org.jupiter.transport.Directory;
import org.jupiter.transport.channel.CopyOnWriteGroupList;
import org.jupiter.transport.channel.JChannelGroup;

public class RandomLoadBalancer
extends AbstractLoadBalancer {
    private static final RandomLoadBalancer instance = new RandomLoadBalancer();

    public static RandomLoadBalancer instance() {
        return instance;
    }

    @Override
    public JChannelGroup select(CopyOnWriteGroupList groups, Directory directory) {
        JChannelGroup[] elements = groups.snapshot();
        int length = elements.length;
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return elements[0];
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (groups.isSameWeight()) {
            return elements[random.nextInt(length)];
        }
        boolean allWarmUpComplete = true;
        int sumWeight = 0;
        WeightArray weightsSnapshot = this.weightArray(length);
        for (int i = 0; i < length; ++i) {
            JChannelGroup group = elements[i];
            int val = this.getWeight(group, directory);
            weightsSnapshot.set(i, val);
            sumWeight += val;
            allWarmUpComplete = allWarmUpComplete && group.isWarmUpComplete();
        }
        boolean sameWeight = true;
        int val_0 = weightsSnapshot.get(0);
        for (int i = 1; i < length && sameWeight; ++i) {
            sameWeight = val_0 == weightsSnapshot.get(i);
        }
        if (allWarmUpComplete && sameWeight) {
            groups.setSameWeight(true);
        }
        if (!sameWeight && sumWeight > 0) {
            int offset = random.nextInt(sumWeight);
            for (int i = 0; i < length; ++i) {
                if ((offset -= weightsSnapshot.get(i)) >= 0) continue;
                return elements[i];
            }
        }
        return elements[random.nextInt(length)];
    }
}

