/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.provider.processor.task;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.jupiter.common.concurrent.RejectedRunnable;
import org.jupiter.common.util.Pair;
import org.jupiter.common.util.Preconditions;
import org.jupiter.common.util.Reflects;
import org.jupiter.common.util.Signal;
import org.jupiter.common.util.StackTraceUtil;
import org.jupiter.common.util.SystemClock;
import org.jupiter.common.util.SystemPropertyUtil;
import org.jupiter.common.util.internal.UnsafeIntegerFieldUpdater;
import org.jupiter.common.util.internal.UnsafeUpdater;
import org.jupiter.common.util.internal.logging.InternalLogger;
import org.jupiter.common.util.internal.logging.InternalLoggerFactory;
import org.jupiter.rpc.DefaultFilterChain;
import org.jupiter.rpc.JFilter;
import org.jupiter.rpc.JFilterChain;
import org.jupiter.rpc.JFilterContext;
import org.jupiter.rpc.JFilterLoader;
import org.jupiter.rpc.JRequest;
import org.jupiter.rpc.OutputBufImpl;
import org.jupiter.rpc.exception.JupiterBadRequestException;
import org.jupiter.rpc.exception.JupiterFlowControlException;
import org.jupiter.rpc.exception.JupiterRemoteException;
import org.jupiter.rpc.exception.JupiterServerBusyException;
import org.jupiter.rpc.exception.JupiterServiceNotFoundException;
import org.jupiter.rpc.flow.control.ControlResult;
import org.jupiter.rpc.flow.control.FlowController;
import org.jupiter.rpc.metric.Metrics;
import org.jupiter.rpc.model.metadata.MessageWrapper;
import org.jupiter.rpc.model.metadata.ResultWrapper;
import org.jupiter.rpc.model.metadata.ServiceWrapper;
import org.jupiter.rpc.provider.ProviderInterceptor;
import org.jupiter.rpc.provider.processor.AbstractProviderProcessor;
import org.jupiter.rpc.tracing.TraceId;
import org.jupiter.rpc.tracing.TracingUtil;
import org.jupiter.serialization.InputBuf;
import org.jupiter.serialization.OutputBuf;
import org.jupiter.serialization.Serializer;
import org.jupiter.serialization.SerializerFactory;
import org.jupiter.transport.LowCopy;
import org.jupiter.transport.Status;
import org.jupiter.transport.channel.JChannel;
import org.jupiter.transport.channel.JFutureListener;
import org.jupiter.transport.payload.JRequestPayload;
import org.jupiter.transport.payload.JResponsePayload;

public class MessageTask
implements RejectedRunnable {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MessageTask.class);
    private static final boolean METRIC_NEEDED = SystemPropertyUtil.getBoolean((String)"jupiter.metric.needed", (boolean)false);
    private static final Signal INVOKE_ERROR = Signal.valueOf(MessageTask.class, (String)"INVOKE_ERROR");
    private static final UnsafeIntegerFieldUpdater<TraceId> traceNodeUpdater = UnsafeUpdater.newIntegerFieldUpdater(TraceId.class, (String)"node");
    private final AbstractProviderProcessor processor;
    private final JChannel channel;
    private final JRequest request;

    public MessageTask(AbstractProviderProcessor processor, JChannel channel, JRequest request) {
        this.processor = processor;
        this.channel = channel;
        this.request = request;
    }

    public void run() {
        MessageWrapper msg;
        AbstractProviderProcessor _processor = this.processor;
        JRequest _request = this.request;
        ControlResult ctrl = _processor.flowControl(_request);
        if (!ctrl.isAllowed()) {
            this.rejected(Status.APP_FLOW_CONTROL, new JupiterFlowControlException(String.valueOf(ctrl)));
            return;
        }
        try {
            JRequestPayload _requestPayload = _request.payload();
            byte s_code = _requestPayload.serializerCode();
            Serializer serializer = SerializerFactory.getSerializer((byte)s_code);
            if (LowCopy.isDecodeLowCopy()) {
                InputBuf inputBuf = _requestPayload.inputBuf();
                msg = (MessageWrapper)serializer.readObject(inputBuf, MessageWrapper.class);
            } else {
                byte[] bytes = _requestPayload.bytes();
                msg = (MessageWrapper)serializer.readObject(bytes, MessageWrapper.class);
            }
            _requestPayload.clear();
            _request.message(msg);
        }
        catch (Throwable t) {
            this.rejected(Status.BAD_REQUEST, new JupiterBadRequestException(t.getMessage()));
            return;
        }
        final ServiceWrapper service = _processor.lookupService(msg.getMetadata());
        if (service == null) {
            this.rejected(Status.SERVICE_NOT_FOUND, new JupiterServiceNotFoundException(String.valueOf(msg)));
            return;
        }
        FlowController<JRequest> childController = service.getFlowController();
        if (childController != null && !(ctrl = childController.flowControl(_request)).isAllowed()) {
            this.rejected(Status.PROVIDER_FLOW_CONTROL, new JupiterFlowControlException(String.valueOf(ctrl)));
            return;
        }
        Executor childExecutor = service.getExecutor();
        if (childExecutor == null) {
            this.process(service);
        } else {
            childExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    MessageTask.this.process(service);
                }
            });
        }
    }

    public void rejected() {
        this.rejected(Status.SERVER_BUSY, new JupiterServerBusyException(String.valueOf(this.request)));
    }

    private void rejected(Status status, JupiterRemoteException cause) {
        if (METRIC_NEEDED) {
            MetricsHolder.rejectionMeter.mark();
        }
        this.processor.handleRejected(this.channel, this.request, status, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(ServiceWrapper service) {
        JRequest _request = this.request;
        Context invokeCtx = new Context(service);
        if (TracingUtil.isTracingNeeded()) {
            MessageTask.setCurrentTraceId(_request.message().getTraceId());
        }
        try {
            Object invokeResult = Chains.invoke(_request, invokeCtx).getResult();
            ResultWrapper result = new ResultWrapper();
            result.setResult(invokeResult);
            byte s_code = _request.serializerCode();
            Serializer serializer = SerializerFactory.getSerializer((byte)s_code);
            JResponsePayload responsePayload = new JResponsePayload(_request.invokeId());
            if (LowCopy.isEncodeLowCopy()) {
                OutputBuf outputBuf = serializer.writeObject((OutputBuf)new OutputBufImpl(this.channel.allocOutput()), (Object)result);
                responsePayload.outputBuf(s_code, outputBuf);
            } else {
                byte[] bytes = serializer.writeObject((Object)result);
                responsePayload.bytes(s_code, bytes);
            }
            responsePayload.status(Status.OK.value());
            this.handleWriteResponse(responsePayload);
        }
        catch (Throwable t) {
            if (INVOKE_ERROR == t) {
                this.handleException(invokeCtx.getExpectCauseTypes(), invokeCtx.getCause());
            } else {
                this.processor.handleException(this.channel, _request, Status.SERVER_ERROR, t);
            }
        }
        finally {
            if (TracingUtil.isTracingNeeded()) {
                TracingUtil.clearCurrent();
            }
        }
    }

    private void handleWriteResponse(JResponsePayload response) {
        this.channel.write((Object)response, (JFutureListener)new JFutureListener<JChannel>(){

            public void operationSuccess(JChannel channel) throws Exception {
                if (METRIC_NEEDED) {
                    long duration = SystemClock.millisClock().now() - MessageTask.this.request.timestamp();
                    MetricsHolder.processingTimer.update(duration, TimeUnit.MILLISECONDS);
                }
            }

            public void operationFailure(JChannel channel, Throwable cause) throws Exception {
                long duration = SystemClock.millisClock().now() - MessageTask.this.request.timestamp();
                logger.error("Response sent failed, trace: {}, duration: {} millis, channel: {}, cause: {}.", new Object[]{MessageTask.this.request.getTraceId(), duration, channel, cause});
            }
        });
    }

    private void handleException(Class<?>[] exceptionTypes, Throwable failCause) {
        if (exceptionTypes != null && exceptionTypes.length > 0) {
            Class<?> failType = failCause.getClass();
            for (Class<?> eType : exceptionTypes) {
                if (!eType.isAssignableFrom(failType)) continue;
                this.processor.handleException(this.channel, this.request, Status.SERVICE_EXPECTED_ERROR, failCause);
                return;
            }
        }
        this.processor.handleException(this.channel, this.request, Status.SERVICE_UNEXPECTED_ERROR, failCause);
    }

    private static Object invoke(MessageWrapper msg, Context invokeCtx) throws Signal {
        ServiceWrapper service = invokeCtx.getService();
        Object provider = service.getServiceProvider();
        String methodName = msg.getMethodName();
        Object[] args = msg.getArgs();
        Timer.Context timerCtx = null;
        if (METRIC_NEEDED) {
            timerCtx = Metrics.timer(msg.getOperationName()).time();
        }
        Class[] expectCauseTypes = null;
        try {
            List<Pair<Class<?>[], Class<?>[]>> methodExtension = service.getMethodExtension(methodName);
            if (methodExtension == null) {
                throw new NoSuchMethodException(methodName);
            }
            Pair bestMatch = Reflects.findMatchingParameterTypesExt(methodExtension, (Object[])args);
            Class[] parameterTypes = (Class[])bestMatch.getFirst();
            expectCauseTypes = (Class[])bestMatch.getSecond();
            Object object = Reflects.fastInvoke((Object)provider, (String)methodName, (Class[])parameterTypes, (Object[])args);
            return object;
        }
        catch (Throwable t) {
            invokeCtx.setCauseAndExpectTypes(t, expectCauseTypes);
            throw INVOKE_ERROR;
        }
        finally {
            if (METRIC_NEEDED) {
                timerCtx.stop();
            }
        }
    }

    private static void handleBeforeInvoke(ProviderInterceptor[] interceptors, TraceId traceId, Object provider, String methodName, Object[] args) {
        for (int i = 0; i < interceptors.length; ++i) {
            try {
                interceptors[i].beforeInvoke(traceId, provider, methodName, args);
                continue;
            }
            catch (Throwable t) {
                logger.error("Interceptor[{}#beforeInvoke]: {}.", (Object)Reflects.simpleClassName((Object)interceptors[i]), (Object)StackTraceUtil.stackTrace((Throwable)t));
            }
        }
    }

    private static void handleAfterInvoke(ProviderInterceptor[] interceptors, TraceId traceId, Object provider, String methodName, Object[] args, Object invokeResult, Throwable failCause) {
        for (int i = interceptors.length - 1; i >= 0; --i) {
            try {
                interceptors[i].afterInvoke(traceId, provider, methodName, args, invokeResult, failCause);
                continue;
            }
            catch (Throwable t) {
                logger.error("Interceptor[{}#afterInvoke]: {}.", (Object)Reflects.simpleClassName((Object)interceptors[i]), (Object)StackTraceUtil.stackTrace((Throwable)t));
            }
        }
    }

    private static void setCurrentTraceId(TraceId traceId) {
        if (traceId != null && traceId != TraceId.NULL_TRACE_ID) {
            assert (traceNodeUpdater != null);
            traceNodeUpdater.set((Object)traceId, traceId.getNode() + 1);
        }
        TracingUtil.setCurrent(traceId);
    }

    static class MetricsHolder {
        static final Timer processingTimer = Metrics.timer("processing");
        static final Meter rejectionMeter = Metrics.meter("rejection");

        MetricsHolder() {
        }
    }

    static class Chains {
        private static final JFilterChain headChain;

        Chains() {
        }

        static <T extends JFilterContext> T invoke(JRequest request, T invokeCtx) throws Throwable {
            headChain.doFilter(request, invokeCtx);
            return invokeCtx;
        }

        static {
            DefaultFilterChain invokeChain = new DefaultFilterChain(new InvokeFilter(), null);
            DefaultFilterChain interceptChain = new DefaultFilterChain(new InterceptorsFilter(), invokeChain);
            headChain = JFilterLoader.loadExtFilters(interceptChain, JFilter.Type.PROVIDER);
        }
    }

    static class InvokeFilter
    implements JFilter {
        InvokeFilter() {
        }

        @Override
        public JFilter.Type getType() {
            return JFilter.Type.PROVIDER;
        }

        @Override
        public <T extends JFilterContext> void doFilter(JRequest request, T filterCtx, JFilterChain next) throws Throwable {
            MessageWrapper msg = request.message();
            Context invokeCtx = (Context)filterCtx;
            Object invokeResult = MessageTask.invoke(msg, invokeCtx);
            invokeCtx.setResult(invokeResult);
        }
    }

    static class InterceptorsFilter
    implements JFilter {
        InterceptorsFilter() {
        }

        @Override
        public JFilter.Type getType() {
            return JFilter.Type.PROVIDER;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T extends JFilterContext> void doFilter(JRequest request, T filterCtx, JFilterChain next) throws Throwable {
            Context invokeCtx = (Context)filterCtx;
            ServiceWrapper service = invokeCtx.getService();
            ProviderInterceptor[] interceptors = service.getInterceptors();
            if (interceptors == null || interceptors.length == 0) {
                next.doFilter(request, filterCtx);
            } else {
                TraceId traceId = TracingUtil.getCurrent();
                Object provider = service.getServiceProvider();
                MessageWrapper msg = request.message();
                String methodName = msg.getMethodName();
                Object[] args = msg.getArgs();
                MessageTask.handleBeforeInvoke(interceptors, traceId, provider, methodName, args);
                try {
                    next.doFilter(request, filterCtx);
                }
                finally {
                    MessageTask.handleAfterInvoke(interceptors, traceId, provider, methodName, args, invokeCtx.getResult(), invokeCtx.getCause());
                }
            }
        }
    }

    public static class Context
    implements JFilterContext {
        private final ServiceWrapper service;
        private Object result;
        private Throwable cause;
        private Class<?>[] expectCauseTypes;

        public Context(ServiceWrapper service) {
            this.service = (ServiceWrapper)Preconditions.checkNotNull((Object)service, (Object)"service");
        }

        public ServiceWrapper getService() {
            return this.service;
        }

        public Object getResult() {
            return this.result;
        }

        public void setResult(Object result) {
            this.result = result;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public Class<?>[] getExpectCauseTypes() {
            return this.expectCauseTypes;
        }

        public void setCauseAndExpectTypes(Throwable cause, Class<?>[] expectCauseTypes) {
            this.cause = cause;
            this.expectCauseTypes = expectCauseTypes;
        }

        @Override
        public JFilter.Type getType() {
            return JFilter.Type.PROVIDER;
        }
    }
}

