/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc;

import java.util.Collections;
import java.util.Map;
import org.jupiter.rpc.model.metadata.MessageWrapper;
import org.jupiter.rpc.tracing.TracingUtil;
import org.jupiter.serialization.OutputBuf;
import org.jupiter.transport.payload.JRequestPayload;

public class JRequest {
    private final JRequestPayload payload;
    private MessageWrapper message;

    public JRequest() {
        this(new JRequestPayload());
    }

    public JRequest(JRequestPayload payload) {
        this.payload = payload;
    }

    public JRequestPayload payload() {
        return this.payload;
    }

    public long invokeId() {
        return this.payload.invokeId();
    }

    public long timestamp() {
        return this.payload.timestamp();
    }

    public byte serializerCode() {
        return this.payload.serializerCode();
    }

    public void bytes(byte serializerCode, byte[] bytes) {
        this.payload.bytes(serializerCode, bytes);
    }

    public void outputBuf(byte serializerCode, OutputBuf outputBuf) {
        this.payload.outputBuf(serializerCode, outputBuf);
    }

    public MessageWrapper message() {
        return this.message;
    }

    public void message(MessageWrapper message) {
        this.message = message;
    }

    public String getTraceId() {
        if (this.message == null) {
            return null;
        }
        return TracingUtil.safeGetTraceId(this.message.getTraceId()).asText();
    }

    public Map<String, String> getAttachments() {
        Map<String, String> attachments = this.message != null ? this.message.getAttachments() : null;
        return attachments != null ? attachments : Collections.emptyMap();
    }

    public void putAttachment(String key, String value) {
        if (this.message != null) {
            this.message.putAttachment(key, value);
        }
    }

    public String toString() {
        return "JRequest{invokeId=" + this.invokeId() + ", timestamp=" + this.timestamp() + ", serializerCode=" + this.serializerCode() + ", message=" + this.message + '}';
    }
}

