/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.consumer.future;

import org.jupiter.common.util.Preconditions;
import org.jupiter.rpc.JListener;
import org.jupiter.rpc.consumer.future.InvokeFuture;
import org.jupiter.rpc.consumer.future.InvokeFutureGroup;

public class DefaultInvokeFutureGroup<V>
implements InvokeFutureGroup<V> {
    private final InvokeFuture<V>[] futures;

    public static <T> DefaultInvokeFutureGroup<T> with(InvokeFuture<T>[] futures) {
        return new DefaultInvokeFutureGroup<T>(futures);
    }

    private DefaultInvokeFutureGroup(InvokeFuture<V>[] futures) {
        Preconditions.checkArgument((futures != null && futures.length > 0 ? 1 : 0) != 0, (Object)"empty futures");
        this.futures = futures;
    }

    @Override
    public Class<V> returnType() {
        return this.futures[0].returnType();
    }

    @Override
    public V getResult() throws Throwable {
        throw new UnsupportedOperationException();
    }

    @Override
    public InvokeFuture<V>[] futures() {
        return this.futures;
    }

    @Override
    public InvokeFutureGroup<V> addListener(JListener<V> listener) {
        for (InvokeFuture<V> f : this.futures) {
            f.addListener(listener);
        }
        return this;
    }

    @Override
    public InvokeFutureGroup<V> addListeners(JListener<V> ... listeners) {
        for (InvokeFuture<V> f : this.futures) {
            f.addListeners(listeners);
        }
        return this;
    }

    @Override
    public InvokeFutureGroup<V> removeListener(JListener<V> listener) {
        for (InvokeFuture<V> f : this.futures) {
            f.removeListener(listener);
        }
        return this;
    }

    @Override
    public InvokeFutureGroup<V> removeListeners(JListener<V> ... listeners) {
        for (InvokeFuture<V> f : this.futures) {
            f.removeListeners(listeners);
        }
        return this;
    }
}

