/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.load.balance;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jupiter.rpc.load.balance.AbstractLoadBalancer;
import org.jupiter.rpc.load.balance.WeightArray;
import org.jupiter.transport.Directory;
import org.jupiter.transport.channel.CopyOnWriteGroupList;
import org.jupiter.transport.channel.JChannelGroup;

public class RoundRobinLoadBalancer
extends AbstractLoadBalancer {
    private static final AtomicIntegerFieldUpdater<RoundRobinLoadBalancer> indexUpdater = AtomicIntegerFieldUpdater.newUpdater(RoundRobinLoadBalancer.class, "index");
    private volatile int index = 0;

    public static RoundRobinLoadBalancer instance() {
        return new RoundRobinLoadBalancer();
    }

    @Override
    public JChannelGroup select(CopyOnWriteGroupList groups, Directory directory) {
        JChannelGroup[] elements = groups.snapshot();
        int length = elements.length;
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return elements[0];
        }
        int index = indexUpdater.getAndIncrement(this) & Integer.MAX_VALUE;
        if (groups.isSameWeight()) {
            return elements[index % length];
        }
        boolean allWarmUpComplete = true;
        int sumWeight = 0;
        WeightArray weightsSnapshot = this.weightArray(length);
        for (int i = 0; i < length; ++i) {
            JChannelGroup group = elements[i];
            int val = this.getWeight(group, directory);
            weightsSnapshot.set(i, val);
            sumWeight += val;
            allWarmUpComplete = allWarmUpComplete && group.isWarmUpComplete();
        }
        int maxWeight = 0;
        int minWeight = Integer.MAX_VALUE;
        for (int i = 0; i < length; ++i) {
            int val = weightsSnapshot.get(i);
            maxWeight = Math.max(maxWeight, val);
            minWeight = Math.min(minWeight, val);
        }
        if (allWarmUpComplete && maxWeight > 0 && minWeight == maxWeight) {
            groups.setSameWeight(true);
        }
        if (maxWeight > 0 && minWeight < maxWeight) {
            int mod = index % sumWeight;
            for (int i = 0; i < maxWeight; ++i) {
                for (int j = 0; j < length; ++j) {
                    int val = weightsSnapshot.get(j);
                    if (mod == 0 && val > 0) {
                        return elements[j];
                    }
                    if (val <= 0) continue;
                    weightsSnapshot.set(j, val - 1);
                    --mod;
                }
            }
        }
        return elements[index % length];
    }
}

