/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.model.metadata;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.jupiter.common.util.Maps;
import org.jupiter.rpc.model.metadata.ServiceMetadata;
import org.jupiter.rpc.tracing.TraceId;

public class MessageWrapper
implements Serializable {
    private static final long serialVersionUID = 1009813828866652852L;
    private String appName;
    private final ServiceMetadata metadata;
    private String methodName;
    private Object[] args;
    private TraceId traceId;
    private Map<String, String> attachments;

    public MessageWrapper(ServiceMetadata metadata) {
        this.metadata = metadata;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public ServiceMetadata getMetadata() {
        return this.metadata;
    }

    public String getGroup() {
        return this.metadata.getGroup();
    }

    public String getServiceProviderName() {
        return this.metadata.getServiceProviderName();
    }

    public String getVersion() {
        return this.metadata.getVersion();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public void setArgs(Object[] args) {
        this.args = args;
    }

    public TraceId getTraceId() {
        return this.traceId;
    }

    public void setTraceId(TraceId traceId) {
        this.traceId = traceId;
    }

    public Map<String, String> getAttachments() {
        return this.attachments;
    }

    public void putAttachment(String key, String value) {
        if (this.attachments == null) {
            this.attachments = Maps.newHashMap();
        }
        this.attachments.put(key, value);
    }

    public String getOperationName() {
        return this.metadata.directory() + "." + this.methodName;
    }

    public String toString() {
        return "MessageWrapper{appName='" + this.appName + '\'' + ", metadata=" + this.metadata + ", methodName='" + this.methodName + '\'' + ", args=" + Arrays.toString(this.args) + ", traceId=" + this.traceId + ", attachments=" + this.attachments + '}';
    }
}

