/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.consumer;

import java.util.Collections;
import java.util.List;
import org.jupiter.common.util.Lists;
import org.jupiter.common.util.Preconditions;
import org.jupiter.common.util.Strings;
import org.jupiter.rpc.DispatchType;
import org.jupiter.rpc.InvokeType;
import org.jupiter.rpc.JClient;
import org.jupiter.rpc.consumer.ConsumerInterceptor;
import org.jupiter.rpc.consumer.cluster.ClusterInvoker;
import org.jupiter.rpc.consumer.dispatcher.DefaultBroadcastDispatcher;
import org.jupiter.rpc.consumer.dispatcher.DefaultRoundDispatcher;
import org.jupiter.rpc.consumer.dispatcher.Dispatcher;
import org.jupiter.rpc.consumer.invoker.AsyncGenericInvoker;
import org.jupiter.rpc.consumer.invoker.GenericInvoker;
import org.jupiter.rpc.consumer.invoker.SyncGenericInvoker;
import org.jupiter.rpc.load.balance.LoadBalancerFactory;
import org.jupiter.rpc.load.balance.LoadBalancerType;
import org.jupiter.rpc.model.metadata.ClusterStrategyConfig;
import org.jupiter.rpc.model.metadata.MethodSpecialConfig;
import org.jupiter.rpc.model.metadata.ServiceMetadata;
import org.jupiter.serialization.SerializerType;
import org.jupiter.transport.Directory;
import org.jupiter.transport.JConnection;
import org.jupiter.transport.JConnector;
import org.jupiter.transport.UnresolvedAddress;

public class GenericProxyFactory {
    private String group;
    private String providerName;
    private String version;
    private JClient client;
    private SerializerType serializerType = SerializerType.getDefault();
    private LoadBalancerType loadBalancerType = LoadBalancerType.getDefault();
    private List<UnresolvedAddress> addresses;
    private InvokeType invokeType = InvokeType.getDefault();
    private DispatchType dispatchType = DispatchType.getDefault();
    private long timeoutMillis;
    private List<MethodSpecialConfig> methodSpecialConfigs;
    private List<ConsumerInterceptor> interceptors;
    private ClusterInvoker.Strategy strategy = ClusterInvoker.Strategy.getDefault();
    private int retries = 2;

    public static GenericProxyFactory factory() {
        GenericProxyFactory factory = new GenericProxyFactory();
        factory.addresses = Lists.newArrayList();
        factory.interceptors = Lists.newArrayList();
        factory.methodSpecialConfigs = Lists.newArrayList();
        return factory;
    }

    private GenericProxyFactory() {
    }

    public GenericProxyFactory group(String group) {
        this.group = group;
        return this;
    }

    public GenericProxyFactory providerName(String providerName) {
        this.providerName = providerName;
        return this;
    }

    public GenericProxyFactory version(String version) {
        this.version = version;
        return this;
    }

    public GenericProxyFactory directory(Directory directory) {
        return this.group(directory.getGroup()).providerName(directory.getServiceProviderName()).version(directory.getVersion());
    }

    public GenericProxyFactory client(JClient client) {
        this.client = client;
        return this;
    }

    public GenericProxyFactory serializerType(SerializerType serializerType) {
        this.serializerType = serializerType;
        return this;
    }

    public GenericProxyFactory loadBalancerType(LoadBalancerType loadBalancerType) {
        this.loadBalancerType = loadBalancerType;
        return this;
    }

    public GenericProxyFactory addProviderAddress(UnresolvedAddress ... addresses) {
        Collections.addAll(this.addresses, addresses);
        return this;
    }

    public GenericProxyFactory addProviderAddress(List<UnresolvedAddress> addresses) {
        this.addresses.addAll(addresses);
        return this;
    }

    public GenericProxyFactory invokeType(InvokeType invokeType) {
        this.invokeType = (InvokeType)((Object)Preconditions.checkNotNull((Object)((Object)invokeType)));
        return this;
    }

    public GenericProxyFactory dispatchType(DispatchType dispatchType) {
        this.dispatchType = (DispatchType)((Object)Preconditions.checkNotNull((Object)((Object)dispatchType)));
        return this;
    }

    public GenericProxyFactory timeoutMillis(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    public GenericProxyFactory addMethodSpecialConfig(MethodSpecialConfig ... methodSpecialConfigs) {
        Collections.addAll(this.methodSpecialConfigs, methodSpecialConfigs);
        return this;
    }

    public GenericProxyFactory addInterceptor(ConsumerInterceptor ... interceptors) {
        Collections.addAll(this.interceptors, interceptors);
        return this;
    }

    public GenericProxyFactory clusterStrategy(ClusterInvoker.Strategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public GenericProxyFactory failoverRetries(int retries) {
        this.retries = retries;
        return this;
    }

    public GenericInvoker newProxyInstance() {
        Preconditions.checkArgument((boolean)Strings.isNotBlank((String)this.group), (Object)"group");
        Preconditions.checkArgument((boolean)Strings.isNotBlank((String)this.providerName), (Object)"providerName");
        Preconditions.checkNotNull((Object)this.client, (Object)"client");
        Preconditions.checkNotNull((Object)this.serializerType, (Object)"serializerType");
        if (this.dispatchType == DispatchType.BROADCAST && this.invokeType == InvokeType.SYNC) {
            throw GenericProxyFactory.reject("broadcast & sync unsupported");
        }
        ServiceMetadata metadata = new ServiceMetadata(this.group, this.providerName, Strings.isNotBlank((String)this.version) ? this.version : "1.0.0");
        JConnector<JConnection> connector = this.client.connector();
        for (UnresolvedAddress address : this.addresses) {
            connector.addChannelGroup((Directory)metadata, connector.group(address));
        }
        Dispatcher dispatcher = this.dispatcher().interceptors(this.interceptors).timeoutMillis(this.timeoutMillis).methodSpecialConfigs(this.methodSpecialConfigs);
        ClusterStrategyConfig strategyConfig = ClusterStrategyConfig.of(this.strategy, this.retries);
        switch (this.invokeType) {
            case SYNC: {
                return new SyncGenericInvoker(this.client.appName(), metadata, dispatcher, strategyConfig, this.methodSpecialConfigs);
            }
            case ASYNC: {
                return new AsyncGenericInvoker(this.client.appName(), metadata, dispatcher, strategyConfig, this.methodSpecialConfigs);
            }
        }
        throw GenericProxyFactory.reject("invokeType: " + (Object)((Object)this.invokeType));
    }

    protected Dispatcher dispatcher() {
        switch (this.dispatchType) {
            case ROUND: {
                return new DefaultRoundDispatcher(this.client, LoadBalancerFactory.loadBalancer(this.loadBalancerType), this.serializerType);
            }
            case BROADCAST: {
                return new DefaultBroadcastDispatcher(this.client, this.serializerType);
            }
        }
        throw GenericProxyFactory.reject("dispatchType: " + (Object)((Object)this.dispatchType));
    }

    private static UnsupportedOperationException reject(String message) {
        return new UnsupportedOperationException(message);
    }
}

