/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.load.balance;

import org.jupiter.common.util.SystemClock;
import org.jupiter.rpc.load.balance.LoadBalancer;
import org.jupiter.rpc.load.balance.WeightArray;
import org.jupiter.transport.Directory;
import org.jupiter.transport.channel.JChannelGroup;

public abstract class AbstractLoadBalancer
implements LoadBalancer {
    private static final ThreadLocal<WeightArray> weightsThreadLocal = new ThreadLocal<WeightArray>(){

        @Override
        protected WeightArray initialValue() {
            return new WeightArray();
        }
    };

    protected WeightArray weightArray(int length) {
        return weightsThreadLocal.get().refresh(length);
    }

    protected int getWeight(JChannelGroup group, Directory directory) {
        int weight = group.getWeight(directory);
        int warmUp = group.getWarmUp();
        int upTime = (int)(SystemClock.millisClock().now() - group.timestamp());
        if (upTime > 0 && upTime < warmUp) {
            weight = (int)((float)upTime / (float)warmUp * (float)weight);
        }
        return weight > 0 ? weight : 0;
    }
}

