/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.provider.processor;

import org.jupiter.common.util.ExceptionUtil;
import org.jupiter.common.util.StackTraceUtil;
import org.jupiter.common.util.internal.logging.InternalLogger;
import org.jupiter.common.util.internal.logging.InternalLoggerFactory;
import org.jupiter.rpc.JRequest;
import org.jupiter.rpc.flow.control.FlowController;
import org.jupiter.rpc.model.metadata.ResultWrapper;
import org.jupiter.rpc.provider.LookupService;
import org.jupiter.serialization.Serializer;
import org.jupiter.serialization.SerializerFactory;
import org.jupiter.transport.Status;
import org.jupiter.transport.channel.JChannel;
import org.jupiter.transport.channel.JFutureListener;
import org.jupiter.transport.payload.JRequestPayload;
import org.jupiter.transport.payload.JResponsePayload;
import org.jupiter.transport.processor.ProviderProcessor;

public abstract class AbstractProviderProcessor
implements ProviderProcessor,
LookupService,
FlowController<JRequest> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractProviderProcessor.class);

    public void handleException(JChannel channel, JRequestPayload request, Status status, Throwable cause) {
        logger.error("An exception was caught while processing request: {}, {}.", (Object)channel.remoteAddress(), (Object)StackTraceUtil.stackTrace((Throwable)cause));
        this.doHandleException(channel, request.invokeId(), request.serializerCode(), status.value(), cause, false);
    }

    public void handleException(JChannel channel, JRequest request, Status status, Throwable cause) {
        logger.error("An exception was caught while processing request: {}, {}.", (Object)channel.remoteAddress(), (Object)StackTraceUtil.stackTrace((Throwable)cause));
        this.doHandleException(channel, request.invokeId(), request.serializerCode(), status.value(), cause, false);
    }

    public void handleRejected(JChannel channel, JRequest request, Status status, Throwable cause) {
        if (logger.isWarnEnabled()) {
            logger.warn("Service rejected: {}, {}.", (Object)channel.remoteAddress(), (Object)StackTraceUtil.stackTrace((Throwable)cause));
        }
        this.doHandleException(channel, request.invokeId(), request.serializerCode(), status.value(), cause, true);
    }

    private void doHandleException(JChannel channel, long invokeId, byte s_code, byte status, Throwable cause, boolean closeChannel) {
        ResultWrapper result = new ResultWrapper();
        cause = ExceptionUtil.cutCause((Throwable)cause);
        result.setError(cause);
        Serializer serializer = SerializerFactory.getSerializer((byte)s_code);
        byte[] bytes = serializer.writeObject((Object)result);
        JResponsePayload response = new JResponsePayload(invokeId);
        response.status(status);
        response.bytes(s_code, bytes);
        if (closeChannel) {
            channel.write((Object)response, JChannel.CLOSE);
        } else {
            channel.write((Object)response, (JFutureListener)new JFutureListener<JChannel>(){

                public void operationSuccess(JChannel channel) throws Exception {
                    logger.debug("Service error message sent out: {}.", (Object)channel);
                }

                public void operationFailure(JChannel channel, Throwable cause) throws Exception {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Service error message sent failed: {}, {}.", (Object)channel, (Object)StackTraceUtil.stackTrace((Throwable)cause));
                    }
                }
            });
        }
    }
}

