/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.consumer.future;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.jupiter.common.util.Signal;
import org.jupiter.common.util.internal.UnsafeUtil;
import sun.misc.Unsafe;

public abstract class AbstractFuture<V> {
    protected static final Signal TIMEOUT = Signal.valueOf(AbstractFuture.class, (String)"TIMEOUT");
    protected static final long SPIN_FOR_TIMEOUT_THRESHOLD = 1000L;
    private volatile int state = 0;
    protected static final int NEW = 0;
    protected static final int COMPLETING = 1;
    protected static final int NORMAL = 2;
    protected static final int EXCEPTIONAL = 3;
    private Object outcome;
    private volatile WaitNode waiters;
    private static final Unsafe UNSAFE = UnsafeUtil.getUnsafe();
    private static final long stateOffset;
    private static final long waitersOffset;

    public boolean isDone() {
        return this.state > 1;
    }

    protected int state() {
        return this.state;
    }

    protected Object outcome() {
        return this.outcome;
    }

    protected V get() throws Throwable {
        int s = this.state;
        if (s <= 1) {
            s = this.awaitDone(false, 0L);
        }
        return this.report(s);
    }

    protected V get(long timeout, TimeUnit unit) throws Throwable {
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        int s = this.state;
        if (s <= 1 && (s = this.awaitDone(true, unit.toNanos(timeout))) <= 1) {
            throw TIMEOUT;
        }
        return this.report(s);
    }

    protected void set(V v) {
        if (UNSAFE.compareAndSwapInt(this, stateOffset, 0, 1)) {
            this.outcome = v;
            UNSAFE.putOrderedInt(this, stateOffset, 2);
            this.finishCompletion(v);
        }
    }

    protected void setException(Throwable t) {
        if (UNSAFE.compareAndSwapInt(this, stateOffset, 0, 1)) {
            this.outcome = t;
            UNSAFE.putOrderedInt(this, stateOffset, 3);
            this.finishCompletion(t);
        }
    }

    protected abstract void done(int var1, Object var2);

    private V report(int s) throws Throwable {
        Object x = this.outcome;
        if (s == 2) {
            return (V)x;
        }
        throw (Throwable)x;
    }

    private void finishCompletion(Object x) {
        WaitNode q;
        block0: while ((q = this.waiters) != null) {
            if (!UNSAFE.compareAndSwapObject(this, waitersOffset, q, null)) continue;
            while (true) {
                WaitNode next;
                Thread t;
                if ((t = q.thread) != null) {
                    q.thread = null;
                    LockSupport.unpark(t);
                }
                if ((next = q.next) == null) break block0;
                q.next = null;
                q = next;
            }
        }
        this.done(this.state, x);
    }

    private int awaitDone(boolean timed, long nanos) throws InterruptedException {
        long startTime = 0L;
        WaitNode q = null;
        boolean queued = false;
        while (true) {
            int s;
            if ((s = this.state) > 1) {
                if (q != null) {
                    q.thread = null;
                }
                return s;
            }
            if (s == 1) {
                Thread.yield();
                continue;
            }
            if (Thread.interrupted()) {
                this.removeWaiter(q);
                throw new InterruptedException();
            }
            if (q == null) {
                if (timed && nanos <= 0L) {
                    return s;
                }
                q = new WaitNode();
                continue;
            }
            if (!queued) {
                q.next = this.waiters;
                queued = UNSAFE.compareAndSwapObject(this, waitersOffset, q.next, q);
                continue;
            }
            if (timed) {
                long parkNanos;
                if (startTime == 0L) {
                    startTime = System.nanoTime();
                    if (startTime == 0L) {
                        startTime = 1L;
                    }
                    parkNanos = nanos;
                } else {
                    long elapsed = System.nanoTime() - startTime;
                    if (elapsed >= nanos) {
                        this.removeWaiter(q);
                        return this.state;
                    }
                    parkNanos = nanos - elapsed;
                }
                if (parkNanos <= 1000L || this.state >= 1) continue;
                LockSupport.parkNanos(this, parkNanos);
                continue;
            }
            LockSupport.park(this);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void removeWaiter(WaitNode node) {
        if (node != null) {
            node.thread = null;
            block0: while (true) {
                pred = null;
                q = this.waiters;
                while (q != null) {
                    s = q.next;
                    if (q.thread != null) {
                        pred = q;
                    } else if (pred != null) {
                        pred.next = s;
                        if (pred.thread == null) {
                            continue block0;
                        }
                    } else {
                        if (AbstractFuture.UNSAFE.compareAndSwapObject(this, AbstractFuture.waitersOffset, q, s)) ** break;
                        continue block0;
                    }
                    q = s;
                }
                break;
            }
        }
    }

    public String toString() {
        String status;
        switch (this.state) {
            case 2: {
                status = "[Completed normally]";
                break;
            }
            case 3: {
                status = "[Completed exceptionally: " + this.outcome + "]";
                break;
            }
            default: {
                status = "[Not completed]";
            }
        }
        return super.toString() + status;
    }

    static {
        try {
            Class<AbstractFuture> k = AbstractFuture.class;
            stateOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("state"));
            waitersOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("waiters"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    static final class WaitNode {
        volatile Thread thread = Thread.currentThread();
        volatile WaitNode next;

        WaitNode() {
        }
    }
}

