/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.consumer.future;

import java.util.Arrays;
import org.jupiter.rpc.JListener;

public class DefaultListeners<V> {
    private JListener<V>[] listeners = new JListener[2];
    private int size;

    static <T> DefaultListeners<T> with(JListener<T> first, JListener<T> second) {
        return new DefaultListeners<T>(first, second);
    }

    private DefaultListeners(JListener<V> first, JListener<V> second) {
        this.listeners[0] = first;
        this.listeners[1] = second;
        this.size = 2;
    }

    public void add(JListener<V> l) {
        int size = this.size;
        JListener<V>[] listeners = this.listeners;
        if (size == listeners.length) {
            this.listeners = listeners = Arrays.copyOf(listeners, size << 1);
        }
        listeners[size] = l;
        this.size = size + 1;
    }

    public void remove(JListener<V> l) {
        JListener<V>[] listeners = this.listeners;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            if (listeners[i] != l) continue;
            int length = size - i - 1;
            if (length > 0) {
                System.arraycopy(listeners, i + 1, listeners, i, length);
            }
            listeners[--size] = null;
            this.size = size;
            return;
        }
    }

    public JListener<V>[] listeners() {
        return this.listeners;
    }

    public int size() {
        return this.size;
    }
}

