/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.executor;

import java.util.concurrent.ThreadFactory;
import net.openhft.affinity.AffinityStrategy;
import org.jupiter.common.concurrent.AffinityNamedThreadFactory;
import org.jupiter.common.concurrent.NamedThreadFactory;
import org.jupiter.common.util.JConstants;
import org.jupiter.common.util.SystemPropertyUtil;
import org.jupiter.rpc.executor.ExecutorFactory;

public abstract class AbstractExecutorFactory
implements ExecutorFactory {
    protected ThreadFactory threadFactory(String name) {
        boolean affinity = SystemPropertyUtil.getBoolean((String)"jupiter.executor.factory.affinity.thread", (boolean)false);
        if (affinity) {
            return new AffinityNamedThreadFactory(name, new AffinityStrategy[0]);
        }
        return new NamedThreadFactory(name);
    }

    protected int coreWorkers(ExecutorFactory.Target target) {
        switch (target) {
            case CONSUMER: {
                return SystemPropertyUtil.getInt((String)"jupiter.executor.factory.consumer.core.workers", (int)(JConstants.AVAILABLE_PROCESSORS << 1));
            }
            case PROVIDER: {
                return SystemPropertyUtil.getInt((String)"jupiter.executor.factory.provider.core.workers", (int)(JConstants.AVAILABLE_PROCESSORS << 1));
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)target));
    }

    protected int maxWorkers(ExecutorFactory.Target target) {
        switch (target) {
            case CONSUMER: {
                return SystemPropertyUtil.getInt((String)"jupiter.executor.factory.consumer.max.workers", (int)32);
            }
            case PROVIDER: {
                return SystemPropertyUtil.getInt((String)"jupiter.executor.factory.provider.max.workers", (int)512);
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)target));
    }

    protected int queueCapacity(ExecutorFactory.Target target) {
        switch (target) {
            case CONSUMER: {
                return SystemPropertyUtil.getInt((String)"jupiter.executor.factory.consumer.queue.capacity", (int)32768);
            }
            case PROVIDER: {
                return SystemPropertyUtil.getInt((String)"jupiter.executor.factory.provider.queue.capacity", (int)32768);
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)target));
    }
}

