/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.load.balance;

import org.jupiter.common.util.IntSequence;
import org.jupiter.rpc.load.balance.LoadBalancer;
import org.jupiter.rpc.load.balance.WeightArray;
import org.jupiter.transport.Directory;
import org.jupiter.transport.channel.CopyOnWriteGroupList;
import org.jupiter.transport.channel.JChannelGroup;

public class RoundRobinLoadBalancer
implements LoadBalancer {
    private final IntSequence sequence = new IntSequence();

    public static RoundRobinLoadBalancer instance() {
        return new RoundRobinLoadBalancer();
    }

    @Override
    public JChannelGroup select(CopyOnWriteGroupList groups, Directory directory) {
        JChannelGroup[] elements = groups.getSnapshot();
        int length = elements.length;
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return elements[0];
        }
        WeightArray weightArray = (WeightArray)groups.getWeightArray(elements, directory.directoryString());
        if (weightArray == null) {
            weightArray = WeightArray.computeWeightArray(groups, elements, directory, length);
        }
        int index = this.sequence.next() & Integer.MAX_VALUE;
        if (weightArray.isAllSameWeight()) {
            return elements[index % length];
        }
        int sumWeight = weightArray.get(length - 1);
        int eVal = index % sumWeight;
        int eIndex = WeightArray.binarySearchIndex(weightArray, length, eVal);
        return elements[eIndex];
    }
}

