/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.load.balance;

import org.jupiter.common.util.SystemClock;
import org.jupiter.transport.Directory;
import org.jupiter.transport.channel.CopyOnWriteGroupList;
import org.jupiter.transport.channel.JChannelGroup;

final class WeightArray {
    private int[] array;

    WeightArray(int length) {
        this.array = new int[length];
    }

    int get(int index) {
        return this.array[index];
    }

    boolean isAllSameWeight() {
        return this.array == null;
    }

    static WeightArray computeWeightArray(CopyOnWriteGroupList groups, JChannelGroup[] elements, Directory directory, int length) {
        WeightArray weightArray = new WeightArray(length);
        boolean allWarmUpComplete = true;
        boolean allSameWeight = true;
        for (int i = 0; i < length; ++i) {
            allWarmUpComplete = allWarmUpComplete && elements[i].isWarmUpComplete();
            int preVal = 0;
            int curVal = WeightArray.getWeight(elements[i], directory);
            if (i > 0) {
                preVal = weightArray.array[i - 1];
                allSameWeight = allSameWeight && preVal == curVal;
            }
            weightArray.array[i] = preVal + curVal;
        }
        if (allWarmUpComplete) {
            if (allSameWeight) {
                weightArray.array = null;
            }
            groups.setWeightArray(elements, directory.directoryString(), (Object)weightArray);
        }
        return weightArray;
    }

    static int getWeight(JChannelGroup group, Directory directory) {
        int weight = group.getWeight(directory);
        int warmUp = group.getWarmUp();
        int upTime = (int)(SystemClock.millisClock().now() - group.timestamp());
        if (upTime > 0 && upTime < warmUp) {
            weight = (int)((float)upTime / (float)warmUp * (float)weight);
        }
        return weight > 0 ? weight : 0;
    }

    static int binarySearchIndex(WeightArray weightArray, int length, int value) {
        int low = 0;
        int high = length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = weightArray.get(mid);
            if (midVal < (long)value) {
                low = mid + 1;
                continue;
            }
            if (midVal > (long)value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low;
    }
}

