/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.provider.processor;

import org.jupiter.rpc.JRequest;
import org.jupiter.rpc.JServer;
import org.jupiter.rpc.executor.CloseableExecutor;
import org.jupiter.rpc.flow.control.ControlResult;
import org.jupiter.rpc.flow.control.FlowController;
import org.jupiter.rpc.model.metadata.ServiceWrapper;
import org.jupiter.rpc.provider.processor.AbstractProviderProcessor;
import org.jupiter.rpc.provider.processor.ProviderExecutors;
import org.jupiter.rpc.provider.processor.task.MessageTask;
import org.jupiter.transport.Directory;
import org.jupiter.transport.channel.JChannel;
import org.jupiter.transport.payload.JRequestPayload;

public class DefaultProviderProcessor
extends AbstractProviderProcessor {
    private final JServer server;
    private final CloseableExecutor executor;

    public DefaultProviderProcessor(JServer server) {
        this(server, ProviderExecutors.executor());
    }

    public DefaultProviderProcessor(JServer server, CloseableExecutor executor) {
        this.server = server;
        this.executor = executor;
    }

    public void handleRequest(JChannel channel, JRequestPayload requestPayload) throws Exception {
        MessageTask task = new MessageTask(this, channel, new JRequest(requestPayload));
        if (this.executor == null) {
            task.run();
        } else {
            this.executor.execute((Runnable)((Object)task));
        }
    }

    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @Override
    public ServiceWrapper lookupService(Directory directory) {
        return this.server.lookupService(directory);
    }

    @Override
    public ControlResult flowControl(JRequest request) {
        FlowController<JRequest> controller = this.server.globalFlowController();
        if (controller == null) {
            return ControlResult.ALLOWED;
        }
        return controller.flowControl(request);
    }
}

