/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.consumer.cluster;

import org.jupiter.common.util.Preconditions;
import org.jupiter.common.util.Reflects;
import org.jupiter.common.util.StackTraceUtil;
import org.jupiter.common.util.internal.logging.InternalLogger;
import org.jupiter.common.util.internal.logging.InternalLoggerFactory;
import org.jupiter.rpc.JListener;
import org.jupiter.rpc.JRequest;
import org.jupiter.rpc.consumer.cluster.ClusterInvoker;
import org.jupiter.rpc.consumer.dispatcher.DefaultRoundDispatcher;
import org.jupiter.rpc.consumer.dispatcher.Dispatcher;
import org.jupiter.rpc.consumer.future.DefaultInvokeFuture;
import org.jupiter.rpc.consumer.future.FailOverInvokeFuture;
import org.jupiter.rpc.consumer.future.InvokeFuture;
import org.jupiter.rpc.model.metadata.MessageWrapper;
import org.jupiter.transport.channel.JChannel;

public class FailOverClusterInvoker
implements ClusterInvoker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(FailOverClusterInvoker.class);
    private final Dispatcher dispatcher;
    private final int retries;

    public FailOverClusterInvoker(Dispatcher dispatcher, int retries) {
        Preconditions.checkArgument((boolean)(dispatcher instanceof DefaultRoundDispatcher), (Object)(Reflects.simpleClassName((Object)dispatcher) + " is unsupported [FailOverClusterInvoker]"));
        this.dispatcher = dispatcher;
        this.retries = retries >= 0 ? retries : 2;
    }

    @Override
    public ClusterInvoker.Strategy strategy() {
        return ClusterInvoker.Strategy.FAIL_OVER;
    }

    @Override
    public <T> InvokeFuture<T> invoke(JRequest request, Class<T> returnType) throws Exception {
        FailOverInvokeFuture<T> future = FailOverInvokeFuture.with(returnType);
        int tryCount = this.retries + 1;
        this.invoke0(request, returnType, tryCount, future, null);
        return future;
    }

    private <T> void invoke0(final JRequest request, final Class<T> returnType, final int tryCount, final FailOverInvokeFuture<T> future, Throwable lastCause) {
        if (tryCount > 0) {
            final InvokeFuture<T> f = this.dispatcher.dispatch(request, returnType);
            f.addListener(new JListener<T>(){

                @Override
                public void complete(T result) {
                    future.setSuccess(result);
                }

                @Override
                public void failure(Throwable cause) {
                    if (logger.isWarnEnabled()) {
                        MessageWrapper message = request.message();
                        JChannel channel = null;
                        if (f instanceof DefaultInvokeFuture) {
                            channel = ((DefaultInvokeFuture)f).channel();
                        }
                        logger.warn("[{}]: [Fail-over] retry, [{}] attempts left, [method: {}], [metadata: {}], {}.", new Object[]{channel, tryCount - 1, message.getMethodName(), message.getMetadata(), StackTraceUtil.stackTrace((Throwable)cause)});
                    }
                    FailOverClusterInvoker.this.invoke0(request, returnType, tryCount - 1, future, cause);
                }
            });
        } else {
            future.setFailure(lastCause);
        }
    }
}

