/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.consumer.future;

import java.net.SocketAddress;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.jupiter.common.util.JConstants;
import org.jupiter.common.util.Maps;
import org.jupiter.common.util.Signal;
import org.jupiter.common.util.StackTraceUtil;
import org.jupiter.common.util.internal.logging.InternalLogger;
import org.jupiter.common.util.internal.logging.InternalLoggerFactory;
import org.jupiter.rpc.DispatchType;
import org.jupiter.rpc.JListener;
import org.jupiter.rpc.JResponse;
import org.jupiter.rpc.consumer.ConsumerInterceptor;
import org.jupiter.rpc.consumer.future.AbstractListenableFuture;
import org.jupiter.rpc.consumer.future.InvokeFuture;
import org.jupiter.rpc.exception.JupiterBizException;
import org.jupiter.rpc.exception.JupiterRemoteException;
import org.jupiter.rpc.exception.JupiterSerializationException;
import org.jupiter.rpc.exception.JupiterTimeoutException;
import org.jupiter.rpc.model.metadata.ResultWrapper;
import org.jupiter.rpc.tracing.TraceId;
import org.jupiter.transport.Status;
import org.jupiter.transport.channel.JChannel;

public class DefaultInvokeFuture<V>
extends AbstractListenableFuture<V>
implements InvokeFuture<V> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultInvokeFuture.class);
    private static final long DEFAULT_TIMEOUT_NANOSECONDS = TimeUnit.MILLISECONDS.toNanos(JConstants.DEFAULT_TIMEOUT);
    private static final ConcurrentMap<Long, DefaultInvokeFuture<?>> roundFutures = Maps.newConcurrentMapLong();
    private static final ConcurrentMap<String, DefaultInvokeFuture<?>> broadcastFutures = Maps.newConcurrentMap();
    private final long invokeId;
    private final JChannel channel;
    private final Class<V> returnType;
    private final long timeout;
    private final long startTime = System.nanoTime();
    private volatile boolean sent = false;
    private ConsumerInterceptor[] interceptors;
    private TraceId traceId;

    public static <T> DefaultInvokeFuture<T> with(long invokeId, JChannel channel, Class<T> returnType, long timeoutMillis, DispatchType dispatchType) {
        return new DefaultInvokeFuture<T>(invokeId, channel, returnType, timeoutMillis, dispatchType);
    }

    private DefaultInvokeFuture(long invokeId, JChannel channel, Class<V> returnType, long timeoutMillis, DispatchType dispatchType) {
        this.invokeId = invokeId;
        this.channel = channel;
        this.returnType = returnType;
        this.timeout = timeoutMillis > 0L ? TimeUnit.MILLISECONDS.toNanos(timeoutMillis) : DEFAULT_TIMEOUT_NANOSECONDS;
        switch (dispatchType) {
            case ROUND: {
                roundFutures.put(invokeId, this);
                break;
            }
            case BROADCAST: {
                broadcastFutures.put(DefaultInvokeFuture.subInvokeId(channel, invokeId), this);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported " + (Object)((Object)dispatchType));
            }
        }
    }

    public JChannel channel() {
        return this.channel;
    }

    @Override
    public Class<V> returnType() {
        return this.returnType;
    }

    @Override
    public V getResult() throws Throwable {
        try {
            return this.get(this.timeout, TimeUnit.NANOSECONDS);
        }
        catch (Signal s) {
            SocketAddress address = this.channel.remoteAddress();
            if (s == TIMEOUT) {
                throw new JupiterTimeoutException(address, this.sent ? Status.SERVER_TIMEOUT : Status.CLIENT_TIMEOUT);
            }
            throw new JupiterRemoteException(s.name(), address);
        }
    }

    @Override
    protected void notifyListener0(JListener<V> listener, int state, Object x) {
        try {
            if (state == 2) {
                listener.complete(x);
            } else {
                listener.failure((Throwable)x);
            }
        }
        catch (Throwable t) {
            logger.error("An exception was thrown by {}.{}, {}.", new Object[]{listener.getClass().getName(), state == 2 ? "complete()" : "failure()", StackTraceUtil.stackTrace((Throwable)t)});
        }
    }

    public void markSent() {
        this.sent = true;
    }

    public ConsumerInterceptor[] interceptors() {
        return this.interceptors;
    }

    public DefaultInvokeFuture<V> interceptors(ConsumerInterceptor[] interceptors) {
        this.interceptors = interceptors;
        return this;
    }

    public TraceId traceId() {
        return this.traceId;
    }

    public DefaultInvokeFuture<V> traceId(TraceId traceId) {
        this.traceId = traceId;
        return this;
    }

    private void doReceived(JResponse response) {
        byte status = response.status();
        if (status == Status.OK.value()) {
            ResultWrapper wrapper = response.result();
            this.set(wrapper.getResult());
        } else {
            this.setException(status, response);
        }
        ConsumerInterceptor[] interceptors = this.interceptors;
        if (interceptors != null) {
            for (int i = interceptors.length - 1; i >= 0; --i) {
                interceptors[i].afterInvoke(this.traceId, response, this.channel);
            }
        }
    }

    private void setException(byte status, JResponse response) {
        Throwable cause;
        if (status == Status.SERVER_TIMEOUT.value()) {
            cause = new JupiterTimeoutException(this.channel.remoteAddress(), Status.SERVER_TIMEOUT);
        } else if (status == Status.CLIENT_TIMEOUT.value()) {
            cause = new JupiterTimeoutException(this.channel.remoteAddress(), Status.CLIENT_TIMEOUT);
        } else if (status == Status.DESERIALIZATION_FAIL.value()) {
            ResultWrapper wrapper = response.result();
            cause = (JupiterSerializationException)wrapper.getResult();
        } else if (status == Status.SERVICE_EXPECTED_ERROR.value()) {
            ResultWrapper wrapper = response.result();
            cause = (Throwable)wrapper.getResult();
        } else if (status == Status.SERVICE_UNEXPECTED_ERROR.value()) {
            ResultWrapper wrapper = response.result();
            String message = String.valueOf(wrapper.getResult());
            cause = new JupiterBizException(message, this.channel.remoteAddress());
        } else {
            ResultWrapper wrapper = response.result();
            Object result = wrapper.getResult();
            cause = result != null && result instanceof JupiterRemoteException ? (JupiterRemoteException)result : new JupiterRemoteException(response.toString(), this.channel.remoteAddress());
        }
        this.setException(cause);
    }

    public static void received(JChannel channel, JResponse response) {
        long invokeId = response.id();
        DefaultInvokeFuture future = (DefaultInvokeFuture)roundFutures.remove(invokeId);
        if (future == null) {
            future = (DefaultInvokeFuture)broadcastFutures.remove(DefaultInvokeFuture.subInvokeId(channel, invokeId));
        }
        if (future == null) {
            logger.warn("A timeout response [{}] finally returned on {}.", (Object)response, (Object)channel);
            return;
        }
        future.doReceived(response);
    }

    public static void fakeReceived(JChannel channel, JResponse response, DispatchType dispatchType) {
        long invokeId = response.id();
        DefaultInvokeFuture future = null;
        if (dispatchType == DispatchType.ROUND) {
            future = (DefaultInvokeFuture)roundFutures.remove(invokeId);
        } else if (dispatchType == DispatchType.BROADCAST) {
            future = (DefaultInvokeFuture)broadcastFutures.remove(DefaultInvokeFuture.subInvokeId(channel, invokeId));
        }
        if (future == null) {
            return;
        }
        future.doReceived(response);
    }

    private static String subInvokeId(JChannel channel, long invokeId) {
        return channel.id() + invokeId;
    }

    static {
        Thread t = new Thread((Runnable)new TimeoutScanner(), "timeout.scanner");
        t.setDaemon(true);
        t.start();
    }

    private static class TimeoutScanner
    implements Runnable {
        private TimeoutScanner() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    for (DefaultInvokeFuture future : roundFutures.values()) {
                        this.process(future, DispatchType.ROUND);
                    }
                    for (DefaultInvokeFuture future : broadcastFutures.values()) {
                        this.process(future, DispatchType.BROADCAST);
                    }
                }
                catch (Throwable t) {
                    logger.error("An exception was caught while scanning the timeout futures {}.", (Object)StackTraceUtil.stackTrace((Throwable)t));
                }
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        private void process(DefaultInvokeFuture<?> future, DispatchType dispatchType) {
            if (future == null || future.isDone()) {
                return;
            }
            if (System.nanoTime() - ((DefaultInvokeFuture)future).startTime > ((DefaultInvokeFuture)future).timeout) {
                JResponse response = new JResponse(((DefaultInvokeFuture)future).invokeId);
                response.status(((DefaultInvokeFuture)future).sent ? Status.SERVER_TIMEOUT : Status.CLIENT_TIMEOUT);
                DefaultInvokeFuture.fakeReceived(((DefaultInvokeFuture)future).channel, response, dispatchType);
            }
        }
    }
}

