/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.load.balance;

import java.util.concurrent.ThreadLocalRandom;
import org.jupiter.rpc.load.balance.LoadBalancer;
import org.jupiter.rpc.load.balance.WeightArray;
import org.jupiter.transport.Directory;
import org.jupiter.transport.channel.CopyOnWriteGroupList;
import org.jupiter.transport.channel.JChannelGroup;

public class RandomLoadBalancer
implements LoadBalancer {
    private static final RandomLoadBalancer instance = new RandomLoadBalancer();

    public static RandomLoadBalancer instance() {
        return instance;
    }

    @Override
    public JChannelGroup select(CopyOnWriteGroupList groups, Directory directory) {
        JChannelGroup[] elements = groups.getSnapshot();
        int length = elements.length;
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return elements[0];
        }
        WeightArray weightArray = (WeightArray)groups.getWeightArray(elements, directory.directoryString());
        if (weightArray == null) {
            weightArray = WeightArray.computeWeightArray(groups, elements, directory, length);
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (weightArray.isAllSameWeight()) {
            return elements[random.nextInt(length)];
        }
        int sumWeight = weightArray.get(length - 1);
        int eVal = random.nextInt(sumWeight) % sumWeight;
        int eIndex = WeightArray.binarySearchIndex(weightArray, length, eVal);
        return elements[eIndex];
    }
}

