/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.tracing;

import java.io.Serializable;

public class TraceId
implements Serializable {
    private static final long serialVersionUID = 2901824755629719770L;
    public static final TraceId NULL_TRACE_ID = TraceId.newInstance("null");
    private final String id;
    private int node;

    public static TraceId newInstance(String id) {
        return new TraceId(id);
    }

    private TraceId(String id) {
        this.id = id;
        this.node = 0;
    }

    public String getId() {
        return this.id;
    }

    public int getNode() {
        return this.node;
    }

    public String asText() {
        return this.id + "_" + this.node;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TraceId traceId = (TraceId)o;
        return this.node == traceId.node && this.id.equals(traceId.id);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.node;
        return result;
    }

    public String toString() {
        return "TraceId{id='" + this.id + '\'' + ", node=" + this.node + '}';
    }
}

