/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc;

import java.util.List;
import org.jupiter.common.util.JServiceLoader;
import org.jupiter.common.util.StackTraceUtil;
import org.jupiter.common.util.internal.logging.InternalLogger;
import org.jupiter.common.util.internal.logging.InternalLoggerFactory;
import org.jupiter.rpc.DefaultFilterChain;
import org.jupiter.rpc.JFilter;
import org.jupiter.rpc.JFilterChain;

public class JFilterLoader {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(JFilterLoader.class);

    public static JFilterChain loadExtFilters(JFilterChain chain, JFilter.Type type) {
        try {
            List sortedList = JServiceLoader.load(JFilter.class).sort();
            for (int i = sortedList.size() - 1; i >= 0; --i) {
                JFilter extFilter = (JFilter)sortedList.get(i);
                JFilter.Type extType = extFilter.getType();
                if (extType != type && extType != JFilter.Type.ALL) continue;
                chain = new DefaultFilterChain(extFilter, chain);
            }
        }
        catch (Throwable t) {
            logger.error("Failed to load extension filters: {}.", (Object)StackTraceUtil.stackTrace((Throwable)t));
        }
        return chain;
    }
}

