/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.consumer;

import java.util.Collections;
import java.util.List;
import org.jupiter.common.util.Lists;
import org.jupiter.common.util.Preconditions;
import org.jupiter.common.util.Proxies;
import org.jupiter.common.util.Strings;
import org.jupiter.rpc.DispatchType;
import org.jupiter.rpc.InvokeType;
import org.jupiter.rpc.JClient;
import org.jupiter.rpc.ServiceProvider;
import org.jupiter.rpc.consumer.ConsumerInterceptor;
import org.jupiter.rpc.consumer.cluster.ClusterInvoker;
import org.jupiter.rpc.consumer.dispatcher.DefaultBroadcastDispatcher;
import org.jupiter.rpc.consumer.dispatcher.DefaultRoundDispatcher;
import org.jupiter.rpc.consumer.dispatcher.Dispatcher;
import org.jupiter.rpc.consumer.invoker.AbstractInvoker;
import org.jupiter.rpc.consumer.invoker.AsyncInvoker;
import org.jupiter.rpc.consumer.invoker.SyncInvoker;
import org.jupiter.rpc.load.balance.LoadBalancerFactory;
import org.jupiter.rpc.load.balance.LoadBalancerType;
import org.jupiter.rpc.model.metadata.ClusterStrategyConfig;
import org.jupiter.rpc.model.metadata.MethodSpecialConfig;
import org.jupiter.rpc.model.metadata.ServiceMetadata;
import org.jupiter.serialization.SerializerType;
import org.jupiter.transport.Directory;
import org.jupiter.transport.JConnection;
import org.jupiter.transport.JConnector;
import org.jupiter.transport.UnresolvedAddress;

public class ProxyFactory<I> {
    private final Class<I> interfaceClass;
    private String group;
    private String providerName;
    private String version;
    private JClient client;
    private SerializerType serializerType = SerializerType.getDefault();
    private LoadBalancerType loadBalancerType = LoadBalancerType.getDefault();
    private List<UnresolvedAddress> addresses;
    private InvokeType invokeType = InvokeType.getDefault();
    private DispatchType dispatchType = DispatchType.getDefault();
    private long timeoutMillis;
    private List<MethodSpecialConfig> methodSpecialConfigs;
    private List<ConsumerInterceptor> interceptors;
    private ClusterInvoker.Strategy strategy = ClusterInvoker.Strategy.getDefault();
    private int retries = 2;

    public static <I> ProxyFactory<I> factory(Class<I> interfaceClass) {
        ProxyFactory<I> factory = new ProxyFactory<I>(interfaceClass);
        factory.addresses = Lists.newArrayList();
        factory.interceptors = Lists.newArrayList();
        factory.methodSpecialConfigs = Lists.newArrayList();
        return factory;
    }

    private ProxyFactory(Class<I> interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    public Class<I> getInterfaceClass() {
        return this.interfaceClass;
    }

    public ProxyFactory<I> group(String group) {
        this.group = group;
        return this;
    }

    public ProxyFactory<I> providerName(String providerName) {
        this.providerName = providerName;
        return this;
    }

    public ProxyFactory<I> version(String version) {
        this.version = version;
        return this;
    }

    public ProxyFactory<I> directory(Directory directory) {
        return this.group(directory.getGroup()).providerName(directory.getServiceProviderName()).version(directory.getVersion());
    }

    public ProxyFactory<I> client(JClient client) {
        this.client = client;
        return this;
    }

    public ProxyFactory<I> serializerType(SerializerType serializerType) {
        this.serializerType = serializerType;
        return this;
    }

    public ProxyFactory<I> loadBalancerType(LoadBalancerType loadBalancerType) {
        this.loadBalancerType = loadBalancerType;
        return this;
    }

    public ProxyFactory<I> addProviderAddress(UnresolvedAddress ... addresses) {
        Collections.addAll(this.addresses, addresses);
        return this;
    }

    public ProxyFactory<I> addProviderAddress(List<UnresolvedAddress> addresses) {
        this.addresses.addAll(addresses);
        return this;
    }

    public ProxyFactory<I> invokeType(InvokeType invokeType) {
        this.invokeType = (InvokeType)((Object)Preconditions.checkNotNull((Object)((Object)invokeType)));
        return this;
    }

    public ProxyFactory<I> dispatchType(DispatchType dispatchType) {
        this.dispatchType = (DispatchType)((Object)Preconditions.checkNotNull((Object)((Object)dispatchType)));
        return this;
    }

    public ProxyFactory<I> timeoutMillis(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    public ProxyFactory<I> addMethodSpecialConfig(MethodSpecialConfig ... methodSpecialConfigs) {
        Collections.addAll(this.methodSpecialConfigs, methodSpecialConfigs);
        return this;
    }

    public ProxyFactory<I> addInterceptor(ConsumerInterceptor ... interceptors) {
        Collections.addAll(this.interceptors, interceptors);
        return this;
    }

    public ProxyFactory<I> clusterStrategy(ClusterInvoker.Strategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public ProxyFactory<I> failoverRetries(int retries) {
        this.retries = retries;
        return this;
    }

    public I newProxyInstance() {
        AbstractInvoker handler;
        Preconditions.checkNotNull(this.interfaceClass, (Object)"interfaceClass");
        ServiceProvider annotation = this.interfaceClass.getAnnotation(ServiceProvider.class);
        if (annotation != null) {
            Preconditions.checkArgument((this.group == null ? 1 : 0) != 0, (Object)(this.interfaceClass.getName() + " has a @ServiceProvider annotation, can't set [group] again"));
            Preconditions.checkArgument((this.providerName == null ? 1 : 0) != 0, (Object)(this.interfaceClass.getName() + " has a @ServiceProvider annotation, can't set [providerName] again"));
            this.group = annotation.group();
            String name = annotation.name();
            this.providerName = Strings.isNotBlank((String)name) ? name : this.interfaceClass.getName();
        }
        Preconditions.checkArgument((boolean)Strings.isNotBlank((String)this.group), (Object)"group");
        Preconditions.checkArgument((boolean)Strings.isNotBlank((String)this.providerName), (Object)"providerName");
        Preconditions.checkNotNull((Object)this.client, (Object)"client");
        Preconditions.checkNotNull((Object)this.serializerType, (Object)"serializerType");
        if (this.dispatchType == DispatchType.BROADCAST && this.invokeType == InvokeType.SYNC) {
            throw ProxyFactory.reject("broadcast & sync unsupported");
        }
        ServiceMetadata metadata = new ServiceMetadata(this.group, this.providerName, Strings.isNotBlank((String)this.version) ? this.version : "1.0.0");
        JConnector<JConnection> connector = this.client.connector();
        for (UnresolvedAddress address : this.addresses) {
            connector.addChannelGroup((Directory)metadata, connector.group(address));
        }
        Dispatcher dispatcher = this.dispatcher().interceptors(this.interceptors).timeoutMillis(this.timeoutMillis).methodSpecialConfigs(this.methodSpecialConfigs);
        ClusterStrategyConfig strategyConfig = ClusterStrategyConfig.of(this.strategy, this.retries);
        switch (this.invokeType) {
            case SYNC: {
                handler = new SyncInvoker(this.client.appName(), metadata, dispatcher, strategyConfig, this.methodSpecialConfigs);
                break;
            }
            case ASYNC: {
                handler = new AsyncInvoker(this.client.appName(), metadata, dispatcher, strategyConfig, this.methodSpecialConfigs);
                break;
            }
            default: {
                throw ProxyFactory.reject("invokeType: " + (Object)((Object)this.invokeType));
            }
        }
        return (I)Proxies.getDefault().newProxy(this.interfaceClass, (Object)handler);
    }

    protected Dispatcher dispatcher() {
        switch (this.dispatchType) {
            case ROUND: {
                return new DefaultRoundDispatcher(this.client, LoadBalancerFactory.loadBalancer(this.loadBalancerType), this.serializerType);
            }
            case BROADCAST: {
                return new DefaultBroadcastDispatcher(this.client, this.serializerType);
            }
        }
        throw ProxyFactory.reject("dispatchType: " + (Object)((Object)this.dispatchType));
    }

    private static UnsupportedOperationException reject(String message) {
        return new UnsupportedOperationException(message);
    }
}

